/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.participant;

import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection.EventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseButtonEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseMovedEvent;

/**
 * Paints a grabbed hand when canvas is grabbed.
 * 
 * TODO: out of order for now, needs to be adapted to scene graph
 * 
 * @author Toni Kalajainen
 */
public class HandPainter extends AbstractCanvasParticipant {

    @Dependency CanvasGrab grab;
    @Dependency SymbolUtil symbols;
    @Dependency TransformUtil util;
    @Dependency MouseUtil mice;

//    @Painter(priority=PointerPainter.CURSOR_PAINT_PRIORITY+10)
//    public void paint(GraphicsContext gc) {
//        assertDependencies();
//        Map<Integer, PointerInfo> pis = grab.getGrabInfo();
//        Collection<MouseInfo> mis = mice.getMiceInfo().values();
//        if (mis.isEmpty()) return;
//
//        // Symbol
//        Image grab = symbols.get(DefaultImages.GRAB32, gc.getGraphics2D().getDeviceConfiguration());
//        double gcx = grab.getBounds().getCenterX();
//        double gcy = grab.getBounds().getCenterY();
//        Image hand = symbols.get(DefaultImages.HAND32, gc.getGraphics2D().getDeviceConfiguration());
//        double hcx = hand.getBounds().getCenterX();
//        double hcy = hand.getBounds().getCenterY();
//
//        for (MouseInfo mi : mis) {
//            GraphicsContext g = gc.clone();
//            PointerInfo pi = pis.get(mi.mouseId);
//            if (pi!=null) {
//                Point2D pos = util.canvasToControl(pi.anchorPos, null);
//                g.getGraphics2D().translate(pos.getX(), pos.getY());
//                g.getGraphics2D().translate(-gcx, -gcy);
//                grab.paint(g);
//            } else {
//                Point2D pos = mi.controlPosition;
//                g.getGraphics2D().translate(pos.getX(), pos.getY());
//                g.getGraphics2D().translate(-gcx, -gcy);
//                hand.paint(g);
//            }
//            g.dispose();
//        }
//    }

    @EventHandler(priority = Integer.MAX_VALUE)
    public boolean handleMouseEvent(MouseEvent e) {
        if (e instanceof MouseMovedEvent || e instanceof MouseButtonEvent)
            setDirty();
        return false;
    }
}
