/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.participant;

import java.awt.Color;
import java.awt.Paint;

import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.HintReflection.HintListener;
import org.simantics.g2d.canvas.impl.SGNodeReflection.SGCleanup;
import org.simantics.g2d.canvas.impl.SGNodeReflection.SGInit;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.BackgroundNode;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintObservable;

/**
 * Paints background wither with KEY_BACKGROUND_COLOR or KEY_BACKGROUND_PAINT.
 * 
 * @see Hints#KEY_BACKGROUND_COLOR
 * @see Hints#KEY_BACKGROUND_PAINT
 * @author Toni Kalajainen
 */
public class BackgroundPainter extends AbstractCanvasParticipant {

    protected BackgroundNode node = null;

    @HintListener(Class=Hints.class, Field="KEY_BACKGROUND_COLOR")
    public void colorChanged(IHintObservable sender, Key key, Object oldValue, Object newValue) {
        if (node != null) {
            Color c = getHint(Hints.KEY_BACKGROUND_COLOR);
            node.setColor(c);
            setDirty();
        }
    }

    @HintListener(Class=Hints.class, Field="KEY_BACKGROUND_PAINT")
    public void paintChanged(IHintObservable sender, Key key, Object oldValue, Object newValue) {
        if (node != null) {
            Paint p = getHint(Hints.KEY_BACKGROUND_PAINT);
            node.setPaint(p);
            setDirty();
        }
    }

    @SGInit(designation = SGDesignation.CONTROL)
    public void initSG(G2DParentNode parent) {
        node = parent.addNode("background", BackgroundNode.class);
        node.setZIndex(Integer.MIN_VALUE / 2);

        Color c = getHint(Hints.KEY_BACKGROUND_COLOR);
        Paint p = getHint(Hints.KEY_BACKGROUND_PAINT);
        node.setColor(c);
        node.setPaint(p);
    }

    @SGCleanup
    public void cleanupSG() {
        if (node != null) {
            node.remove();
            node = null;
        }
    }

}