/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.example.chassis;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.chassis.IChassisListener;
import org.simantics.g2d.chassis.SWTChassis;
import org.simantics.g2d.example.TestCanvas;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class ViewPartExample extends ViewPart {
    SWTChassis c;

    @Override
    public void createPartControl(Composite parent) {
        c = new SWTChassis(parent, 0);
        c.syncPopulate();

        IThreadWorkQueue thread = AWTThread.getThreadAccess();
        CanvasContext canvasContext = TestCanvas.createTestCanvas(thread);

        c.setCanvasContext(canvasContext);

        c.addChassisListener(new IChassisListener() {
            @Override
            public void chassisClosed(ICanvasChassis sender) {
                // Prevent deadlock while disposing which using syncExec would result in. 
                ThreadUtils.asyncExec(c.getCanvasContext().getThreadAccess(), new Runnable() {
                    @Override
                    public void run() {
                        ICanvasContext ctx = c.getCanvasContext();
                        c.getAWTComponent().setCanvasContext(null);
                        ctx.dispose();
                    }
                });
            }
        });
    }

    @Override
    public void setFocus() {
        c.setFocus();
    }

}
