/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.example.chassis;

import java.applet.Applet;
import java.awt.GridLayout;

import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.example.TestCanvas;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * @author Toni Kalajainen
 *
 */
public class AppletExample extends Applet {

    private static final long serialVersionUID = 8547571658314750189L;

    @Override
    public void init() {
        // This is an empty content area in the frame
        AWTChassis chassis = new AWTChassis();

        // There is a background painter in canvas context (==it is opaque)
        this.setLayout(new GridLayout(1, 1) );
        chassis.setOpaque(true);
        this.add(chassis);
        chassis.requestFocus();
        chassis.setDoubleBuffered(true);

        IThreadWorkQueue    thread  = AWTThread.getThreadAccess();
        CanvasContext       ctx     = TestCanvas.createDefaultCanvas(thread);
        IHintContext        hintCtx = ctx.getDefaultHintContext();
        IDiagram            diagram = TestCanvas.createDiagram1();

        hintCtx.setHint(DiagramHints.KEY_DIAGRAM, diagram);
        chassis.setCanvasContext(ctx);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

}
