/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.util.Collection;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TerminalTopology;

/**
 * @author Toni Kalajainen
 */
public class ProxyNode implements TerminalTopology {

    private static final long serialVersionUID = -7155777279633175667L;

    TerminalTopology orig;
    IProxyProvider provider;

    public ProxyNode(IProxyProvider provider, TerminalTopology orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public void getTerminals(IElement e, Collection<Terminal> result) {
        orig.getTerminals(provider.provide(e), result);
    }

}
