/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;


/**
 * @author Toni Kalajainen
 */
public class ProxyEdgeBends implements BendsHandler {

	private static final long serialVersionUID = 4166513019494895193L;
	BendsHandler orig;
	IProxyProvider provider;
	
	public ProxyEdgeBends(IProxyProvider provider, BendsHandler orig) {
		this.provider = provider;
		this.orig = orig;
	}

	@Override
	public AngleType getAngleType(IElement e) {
		return orig.getAngleType(e);
	}

	@Override
	public void setAngleType(IElement e, AngleType angleType) {
		orig.setAngleType(e, angleType);
	}

	@Override
	public void getBends(IElement e, List<Bend> bends) {
		orig.getBends(e, bends);
	}

	@Override
	public Bend addBend(IElement e, int index, Point2D pos) {
		return orig.addBend(e, index, pos);
	}

	@Override
	public void getBendPosition(IElement e, Bend b, Point2D pos) {
		orig.getBendPosition(e, b, pos);
	}

	@Override
	public boolean removeBend(IElement e, Bend b) {
		return orig.removeBend(e, b);
	}

	@Override
	public Path2D getPath(IElement e) {
		return orig.getPath(e);
	}

	@Override
	public void setPath(IElement e, Path2D p) {
		orig.setPath(e, p);
	}

	@Override
	public int getBendsCount(IElement e) {
		return orig.getBendsCount(e);
	}

	@Override
	public void moveBend(IElement e, Bend b, Point2D pos) {
		orig.moveBend(e, b, pos);
	}
	
}
