/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.Point2D;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;

/**
 * Clickable class can used three different ways:
 * 
 * 1) Sub-class it and override onClicked
 * 
 * 2) Use Clickable.getPressStatus() from other element handler, e.g. painter
 * 
 * 3) Add ClickListener
 * 
 * 
 * @author Toni Kalajainen
 */
public class TogglableImpl extends AbstractTogglable {

    private static final long         serialVersionUID = 7785780650947251222L;

    public static final TogglableImpl INSTANCE         = new TogglableImpl();

    @Override
    protected boolean onPickCheck(IElement e, ICanvasContext ctx, int pointerId, Point2D pickPos) {
        PickRequest req = new PickRequest(pickPos);
        return ElementUtils.pickInElement(e, ctx, req);
    }

}
