/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.InternalSize;

/**
 * Handler for elements with fixed internal size (eg vector symbols). 
 * 
 * @author Toni Kalajainen
 */
public class FixedSize implements InternalSize {

    private static final long serialVersionUID = -3597595326131594492L;

    public static InternalSize of(double width, double height)
    {
        return new FixedSize(0, 0, width, height);
    }

    public static InternalSize of(double minX, double minY, double width, double height)
    {
        return new FixedSize(minX, minY, width, height);
    }

    public static InternalSize of(Rectangle2D bounds)
    {
        return new FixedSize(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    final Double aspectRatio;
    Rectangle2D bounds;

    FixedSize(double minX, double minY, double width, double height)
    {
        this.aspectRatio = width / height;
        bounds = new Rectangle2D.Double(minX, minY, width, height);
    }

    @Override
    public Rectangle2D getBounds(IElement e, Rectangle2D s) {
        if (s==null) s = new Rectangle2D.Double();
        s.setFrame(bounds);		
        return s;
    }


}
