/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.geom.Point2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Single;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.Scaleable;

/**
 * Interface that tags that the element is scalable. Scaling modifies the 
 * transform of the element (on canvas), where as resizeing modifies the internal
 * size of the element.
 * 
 * @see DefaultTransform default impl
 * @see Scaleable default impl
 * @author Toni Kalajainen
 */
@Single
public interface Scale extends ElementHandler {

	/**
	 * Get scale of the element
	 * @param e
	 * @return
	 */
	Point2D getScale(IElement e);
	
	/**
	 * Set scale of the element
	 * @param e
	 * @param newScale
	 */
	void setScale(IElement e, Point2D newScale);
	
	/**
	 * Returns fixed width/height ratio of dimensions if there is one
	 *  
	 * @return aspect ratio or null 
	 */
	Double getFixedAspectRatio(IElement e);
	
	/**
	 * Return minimum scale if there is one 
	 * @return minimum scale or null
	 */
	Point2D getMinimumScale(IElement e);
	
	/**
	 * return maximum scale if one exists
	 * @return max scale or null
	 */
	Point2D getMaximumScale(IElement e);
	
}