/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Single;

/**
 * A handler for retrieving the parent element of a of an element. Elements can
 * receive a parent when they are grouped.
 * 
 * @author Tuukka Lehtonen
 */
@Single
public interface Parent extends ElementHandler {

    /**
     * @param element the element to check for a parent element
     * @return <code>null</code> if the specified element has no parent element.
     */
    IElement getParent(IElement element);

}
