/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.HoverImpl;

public interface Hover extends ElementHandler {
    
    public static final Hover INSTANCE = new HoverImpl();
    
    /**
     * @param e the element to retrieve hover status from
     * @return 
     */
    public boolean isHovering(IElement e);

    /**
     * @param e the element to set hover status for
     * @param hover the hover status of the element
     */
    public void setHover(IElement e, boolean hover);
}