/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.layers.ILayers;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.routing.IRouter2;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;
import org.simantics.utils.page.MarginUtils.Margins;

/**
 * These hints are meant to be used with IDiagram instances.
 * 
 * @author Toni Kalajainen
 */
public class DiagramHints {

    /**
     * A hint for disabling painting of the diagram the hint is associated with.
     * 
     * <p>
     * By default diagram viewers perform a zoom-to-fit operation on the opened
     * diagram immediately after opening. Sometimes it is desirable to allow
     * disabling of this fitting process. Due to the SWT/AWT interplay nature of
     * diagram editors, the process of zoom-to-fit is rather asynchronous and
     * needs to schedule runnables into the toolkit threads. Since editor
     * opening is synchronously performed in the SWT thread we can safely veto
     * the zoom-to-fit operation by removing this hint from the diagram after
     * opening the editor.
     * 
     * <p>
     * Can also be set for an {@link ICanvasContext} to enable or disable
     * initial zoom to fit for the context regardless of the diagram in
     * question.
     */
    public static final Key KEY_INITIAL_ZOOM_TO_FIT   = new KeyOf(Boolean.class, "INITIAL_ZOOM_TO_FIT");

    /** Diagram */
    public static final Key KEY_DIAGRAM               = new KeyOf(IDiagram.class, "DIAGRAM");

    public static final Key KEY_SELECTION_FRAME_COLOR = new KeyOf(Color.class, "SELECTION_FRAME_COLOR");

    public static final Key KEY_TEXT                  = new KeyOf(String.class, "DIAGRAM_TEXT");

    public static final Key KEY_CANVAS_COLOR          = new KeyOf(Color.class, "CANVAS_COLOR");

    // Layer composition List<LayerInfo>
    public static final Key KEY_LAYER_COMPOSITION     = new KeyOf(List.class, "LAYER_COMPOSITION");

    // public static final Key KEY_BOUNDS = ElementHints.KEY_BOUNDS;

    public final static Key KEY_MARGINS               = new KeyOf(Margins.class, "MARGINS");

    public final static Key KEY_MARGINS_NO_RULER      = new KeyOf(Margins.class, "MARGINS_NO_RULER");

    /**
     * For diagrams, this hint defines the default routing algorithm applied to
     * any connection that does not defined its own routing. For connection
     * elements, this hint defines the selected connection-specific routing
     * strategy.
     */
    public static final Key ROUTE_ALGORITHM           = new KeyOf(IRouter2.class, "ROUTE_ALGORITHM");

    public static final Key PROPERTIES                = new KeyOf(Map.class, "PROPERTIES");

    public static final Key CONNECTION_ADVISOR        = new KeyOf(IConnectionAdvisor.class, "CONNECTION_ADVISOR");

    public static final Key SNAP_ADVISOR              = new KeyOf(ISnapAdvisor.class, "SNAP_ADVISOR");

    public static final Key KEY_LAYERS                = new KeyOf(ILayers.class, "LAYERS");

    public static final Key KEY_LAYERS_EDITOR         = new KeyOf(ILayersEditor.class, "LAYERS_EDITOR");

    public static final Key KEY_FIXED_LAYERS          = new KeyOf(String[].class, "FIXED_LAYERS");

    public static final Key KEY_MUTATOR                = new KeyOf(DiagramMutator.class, "MUTATIONS");

    public static final Key KEY_NAVIGATION_ENABLED = new KeyOf(Boolean.class, "NAVIGATION_ENABLED");

    /**
     * A hint for describing the target rasterized size of element images in a
     * diagram. This is useful for UI components like the symbol library which
     * always shows symbols in a certain size in pixels. Images are generally
     * pre-rasterized and mipmapped in order to speed up SVG rendering. This
     * allows making sure that the symbol is properly rasterized at its target
     * resolution instead of having to resort to mipmaps. If this hint is not provided,
     * a default procedure for resolving the mipmap sizes is followed.
     */
    public static final Key KEY_ELEMENT_RASTER_TARGET_SIZE = new KeyOf(Point.class, "ELEMENT_RASTER_TARGET_SIZE");

    /**
     * This hint is used to mark an element that is being inline edited on a
     * diagram. This hint can be used for example to make sure that only one
     * element is being inline edited at any given time on a single diagram.
     */
    public static final Key KEY_ACTIVE_INLINE_EDITOR = new KeyOf(ICanvasParticipant.class, "ACTIVE_INLINE_EDITOR");

    /**
     * <code>true</code> to allow connection branching. <code>null</code> or
     * <code>false</code> will disable connection branching.
     * 
     * This is a hint for editing, not for visualisation.
     * 
     * If the hint is not present, the default interpretation should be to allow branching.
     */
    public static final Key KEY_ALLOW_CONNECTION_BRANCHING = new KeyOf(Boolean.class, "ALLOW_CONNECTION_BRANCHING");

    /**
     * <code>true</code> to create flags when connections are left in the air,
     * <code>null</code> or <code>false</code> will leave the connections
     * hanging in the air.
     * 
     * This is a hint for editing, not for visualisation.
     * 
     * If the hint is not present, the default interpretation should be not to
     * use connection flags.
     */
    public static final Key KEY_USE_CONNECTION_FLAGS = new KeyOf(Boolean.class, "USE_CONNECTION_FLAGS");

    /**
     * <code>true</code> to allow adding of route points into connections or
     * <code>false</code> to deny route points from being added/created.
     * 
     * This is a hint for editing, not for visualisation.
     * 
     * If the hint is not present, the default interpretation should be to use
     * route points
     */
    public static final Key KEY_ALLOW_ROUTE_POINTS = new KeyOf(Boolean.class, "ALLOW_ROUTE_POINTS");


    /**
     * A Hint for other participants to use for showing the context menu at the
     * contol position specified by the Point2D argument.
     */
    public static final Key SHOW_POPUP_MENU                = new KeyOf(Point2D.class, "SHOW_POPUP_MENU_CMD");

    /**
     * Screen position of mouse on canvas control when the menu was invoked to
     * be opened. For use by menu contributions.
     */
    public static final Key POPUP_MENU_CONTROL_POSITION    = new KeyOf(Point2D.class, "POPUP_MENU_CONTROL_POSITION");

    /**
     * Canvas position of mouse on canvas control when the menu was invoked to
     * be opened. For use by menu contributions.
     */
    public static final Key POPUP_MENU_CANVAS_POSITION     = new KeyOf(Point2D.class, "POPUP_MENU_CANVAS_POSITION");

    /**
     * {@link System#currentTimeMillis()} from the time of processing the popup
     * menu show event.
     */
    public static final Key POPUP_MENU_SHOWN               = new KeyOf(Long.class, "POPUP_MENU_SHOWN");

    /**
     * {@link System#currentTimeMillis()} from the time of processing the popup
     * menu hide event.
     */
    public static final Key POPUP_MENU_HIDDEN              = new KeyOf(Long.class, "POPUP_MENU_HIDDEN");

}
