/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.g2d.chassis;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;


/**
 * Canvas chassis is a user operable base for canvas contexts
 *
 * @See {@link AWTChassis}
 * @See {@link SWTChassis}
 * @See {@link FullscreenChassis} Full screen chassis
 * @See {@link ImageChassis} Renders to a bitmap
 */
public interface ICanvasChassis {

    /**
     * Get the hint context of the chassis
     * @return
     */
    IHintContext getHintContext();
    
    /**
     * Set canvas context into the chassis
     */
    void setCanvasContext(ICanvasContext canvasContext);
    
    /**
     * Get canvas context
     * @return <code>null</code> if the chassis has no canvas context at the moment
     */
    ICanvasContext getCanvasContext();
    
    /**
     * Add chassis listener
     * @param threadAccess
     * @param listener
     */
    void addChassisListener(IThreadWorkQueue threadAccess, IChassisListener listener);
    
    /**
     * 
     * @param threadAccess
     * @param listener
     */
    void removeChassisListener(IThreadWorkQueue threadAccess, IChassisListener listener);
    
    /**
     * 
     * @param listener
     */
    void addChassisListener(IChassisListener listener);
    
    /**
     * 
     * @param listener
     */
    void removeChassisListener(IChassisListener listener);
    
}
