package org.simantics.document.swt.core.widget;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.scl.ui.editor.SCLTextEditorNew;
import org.simantics.scl.ui.editor.TextAndErrors;
import org.simantics.utils.ui.workbench.FocusContextActivator;

public class SCLTextEditor extends LeafWidgetManager<SCLTextEditorNew> {
	
	public static class State {
		
		final private SWTDocument document;
		final private SCLTextEditorNew editor;
		public AbstractEventHandler onModify;

		public State(SWTDocument document, SCLTextEditorNew editor) {
			this.document = document;
			this.editor = editor;
		}

		public void fireText() {
			if(onModify != null) {
				CommandContextImpl parameters = new CommandContextImpl();
				parameters.putString("text", editor.getContent());
				document.post(onModify, parameters);
			}
		}
		
	}
	
	@Override
	protected SCLTextEditorNew doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
		
		SCLTextEditorNew editor = new SCLTextEditorNew(parent, SWT.NONE);
		State state = new State(document, editor);

		editor.viewer.getTextWidget().setData("state", state);
		new FocusContextActivator("org.simantics.document.swt.core.widget.SCLTextEditor", editor.viewer.getTextWidget(), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        
		return editor;
		
	}
	
	@Override
	protected void doUpdateProperties(SWTDocument document, SCLTextEditorNew control, JSONObject object) {

		if(control.isDisposed()) return;
		
		TextAndErrors textAndErrors = object.getValue("textAndErrors");
		if(textAndErrors == null) return;

		// Disable updates during setContent

		int caret = control.viewer.getTextWidget().getCaretOffset();
		
		control.setContent(textAndErrors.text, textAndErrors.errors);
		
		// For updates, restore caret
		control.viewer.getTextWidget().setCaretOffset(caret);
		
		final AbstractEventHandler onModify = object.getValue("onModify");
		State state = (State)control.viewer.getTextWidget().getData("state");
		state.onModify = onModify;
		
	}
	
}
