package org.simantics.document.swt.core.widget;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.simantics.datatypes.literal.RGB;
import org.simantics.document.server.JSONObject;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.HasWidgetsWidgetManager;
import org.simantics.document.swt.core.bean.MarginsBean;

public class GridComposite extends HasWidgetsWidgetManager<Composite> {

	@Override
	protected void doUpdateProperties(SWTDocument document, Composite control, JSONObject object) {
	}

	@Override
	protected Composite doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
		
		MarginsBean extendedMargins = object.getBeanJSONFieldDefault("extendedMargins", MarginsBean.BINDING, new MarginsBean(0, 0, 0, 0));
		RGB.Integer background = object.getBeanJSONFieldDefault("background", RGB.Integer.BINDING, new RGB.Integer(255,0, 0));
		Integer numColumns = object.getJSONFieldDefault("numColumns", 1);
		
		Composite result = new Composite(parent, SWT.NONE);
		GridLayoutFactory.fillDefaults().
			numColumns(numColumns).
			extendedMargins(extendedMargins.left, extendedMargins.right, extendedMargins.top, extendedMargins.bottom).
			spacing(0, 0).
			applyTo(result);
		result.setBackground(document.getColor(background));
		return result;
		
	}
	
}
