package org.simantics.document.swt.core.widget;

import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.bean.DataDefinition;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.client.WidgetManager;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.PostEventCommand;
import org.simantics.document.swt.core.base.PropertyWidgetManager;

public class CommandEventWidget  extends PropertyWidgetManager<Object> {

    @Override
    public Object createWidget(JSONObject object) {
        return null;
    }

    @Override
    public void updateProperties(SWTDocument document, JSONObject object, Object widget) {
        // No properties
    }

    @Override
    public void updateChildren(SWTDocument document, JSONObject object, Object widget,
            TreeMap<String, WidgetData> childMap) {
        // No children
    }

    @Override
    public IEventCommand eventCommand(SWTDocument document, JSONObject object, Object component, String command) {
        if("event".equals(command)) {
            List<DataDefinition> dataDefinitions = object.getJSONField("dataDefinitions");
            HashMap<String, String> data = new HashMap<String, String>();
            for(DataDefinition dd : dataDefinitions) {
                WidgetData wd = document.getWidgetData().get(dd.getElementId());
                if(wd != null && wd.object != null) {
                    @SuppressWarnings("rawtypes")
                    WidgetManager manager = document.getManager(wd.object);
                    if(manager != null) {
                        @SuppressWarnings("unchecked")
                        String result = manager.getProperty(document, wd.object, wd.widget, dd.getProperty());
                        data.put(dd.getTarget(), result);
                    }
                }
            }
            AbstractEventHandler handler = object.getJSONField("SCLFunction");
            return new PostEventCommand(document, handler, data);
        } else {
            return null;
        }
    }
    
}
