package org.simantics.document.swt.core.base;

import java.util.Map;

import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.swt.core.SWTDocument;

public class PostEventCommand extends AbstractEventCommand {
    
    private AbstractEventHandler handler;
    private CommandContextImpl parameters;
    
    public PostEventCommand(SWTDocument document, AbstractEventHandler handler, Map<String, String> parameters) {
        this(document, handler, parameters, null);
    }
    
    public PostEventCommand(SWTDocument document, AbstractEventHandler handler, Map<String, String> parameters, PostEventCommand next) {
        super(document);
        this.handler = handler;
        this.parameters = new CommandContextImpl();
        for(Map.Entry<String, String> entry : parameters.entrySet()) {
        	this.parameters.putString(entry.getKey(), entry.getValue());
        }
        this.next = next;
    }

    @Override
    public void handleCommand() {
        document.post(handler, parameters);
    }

    @Override
    public void commandSuccess() {
        if(next != null)
            next.handleCommand();
    }

    @Override
    public void commandError(String errorMessage) {
        System.err.println(this + " failed: " + errorMessage);
    }

}
