/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection;

import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.FlagHandler;
import org.simantics.structural2.modelingRules.CPIgnore;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.ConnectionJudgementType;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.IModelingRules;

public class ModelledConnectionAdvisor
implements IConnectionAdvisor {
    protected IModelingRules modelingRules;
    protected Session session;

    public ModelledConnectionAdvisor(IModelingRules modelingRules, Session session) {
        this.modelingRules = modelingRules;
        this.session = session;
    }

    protected IConnectionPoint getConnectionPoint(ReadGraph g, IElement element, Topology.Terminal term) throws DatabaseException {
        return this.getConnectionPoint(g, element, term, false);
    }

    protected IConnectionPoint getConnectionPoint(ReadGraph g, IElement element, Topology.Terminal term, boolean ignoreUnrecognized) throws DatabaseException {
        Object obj = null;
        if (element != null) {
            obj = ElementUtils.getObject((IElement)element);
        }
        if (obj instanceof Resource) {
            Resource elementResource = (Resource)obj;
            return ConnectionUtil.toConnectionPoint(g, elementResource, term);
        }
        if (element.getElementClass().containsClass(FlagHandler.class)) {
            return CPIgnore.NULL_INSTANCE;
        }
        if (ignoreUnrecognized) {
            return CPIgnore.NULL_INSTANCE;
        }
        throw new IllegalArgumentException("Cannot get IConnectionPoint for (element,terminal) pair:\n\t" + element + "\n\t" + term);
    }

    public Object canBeConnected(Object backend, final IElement element1, final Topology.Terminal term1, final IElement element2, final Topology.Terminal term2) {
        try {
            if (backend == null) {
                backend = this.session;
            }
            return ((RequestProcessor)backend).syncRequest((Read)new Read<Object>(){

                public Object perform(ReadGraph g) throws DatabaseException {
                    return ModelledConnectionAdvisor.this.canBeConnected(g, element1, term1, element2, term2);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean canBeginConnection(Object backend, final IElement element, final Topology.Terminal term) {
        try {
            if (backend == null) {
                backend = this.session;
            }
            return (Boolean)((RequestProcessor)backend).syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph g) throws DatabaseException {
                    return ModelledConnectionAdvisor.this.canBeginConnection(g, element, term);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Object canBeConnected(ReadGraph graph, IElement element1, Topology.Terminal term1, IElement element2, Topology.Terminal term2) throws DatabaseException {
        ArrayList<IConnectionPoint> cps = new ArrayList<IConnectionPoint>(2);
        if (element1 != null) {
            cps.add(this.getConnectionPoint(graph, element1, term1, true));
        }
        if (element2 != null) {
            cps.add(this.getConnectionPoint(graph, element2, term2, true));
        }
        ConnectionJudgement judgement = this.modelingRules.judgeConnection(graph, cps);
        if (judgement.type == ConnectionJudgementType.LEGAL || judgement.type == ConnectionJudgementType.CANBEMADELEGAL) {
            return judgement;
        }
        return null;
    }

    protected boolean canBeginConnection(ReadGraph graph, IElement element, Topology.Terminal term) throws DatabaseException {
        return this.modelingRules.judgeConnection((ReadGraph)graph, Arrays.asList(new IConnectionPoint[]{this.getConnectionPoint((ReadGraph)graph, (IElement)element, (Topology.Terminal)term)})).type != ConnectionJudgementType.ILLEGAL;
    }
}

