/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services.adaption.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;

public class ReflectionAdapter2<T> implements Adapter<T, Resource> {

	Constructor<? extends T> constructor;
	IDynamicAdapter2[] parameters;
	
	public ReflectionAdapter2(Class<? extends T> clazz, IDynamicAdapter2 ... parameters) throws SecurityException, NoSuchMethodException, DatabaseException {
		Class<?>[] parameterTypes = new Class<?>[parameters.length];
		for(int i=0;i<parameters.length;++i)
			parameterTypes[i] = parameters[i].getType();
		this.constructor = clazz.getConstructor(parameterTypes);
		this.parameters = parameters;
	}
	
    @Override
    public void adapt(AsyncReadGraph g, final Resource source, final Resource r, final AsyncProcedure<T> procedure) {

    	if(parameters.length == 0) {
    	    
//            System.out.println("ReflectionAdapter2 " + ReflectionAdapter2.this);

    	    try {
                procedure.execute(g, constructor.newInstance());
            } catch (IllegalArgumentException e) {
                procedure.exception(g, e);
                e.printStackTrace();
            } catch (InstantiationException e) {
                procedure.exception(g, e);
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                procedure.exception(g, e);
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                procedure.exception(g, e.getCause());
                e.getCause().printStackTrace();
            }
            
    	} else if( parameters.length == 1 && parameters[0] instanceof ThisResource2) {

    	    try {
                procedure.execute(g, constructor.newInstance(r));
            } catch (IllegalArgumentException e) {
                procedure.exception(g, e);
                e.printStackTrace();
            } catch (InstantiationException e) {
                procedure.exception(g, e);
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                procedure.exception(g, e);
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                procedure.exception(g, e.getCause());
                e.getCause().printStackTrace();
            }
    		
    	} else {
    	
            g.asyncRequest(new ReadRequest() {
    
                @Override
                public void run(ReadGraph graph) throws DatabaseException {
                	
                    Object[] args = new Object[parameters.length];
                    try {
                    	for(int i=0;i<parameters.length;++i)
                    		args[i] = parameters[i].adapt(graph, r);
                    	procedure.execute(graph, constructor.newInstance(args));
    				} catch (IllegalArgumentException e) {
    				    procedure.exception(graph, e);
    					e.printStackTrace();
    				} catch (InstantiationException e) {
                        procedure.exception(graph, e);
    					e.printStackTrace();
    				} catch (IllegalAccessException e) {
                        procedure.exception(graph, e);
    					e.printStackTrace();
    				} catch (InvocationTargetException e) {
                        procedure.exception(graph, e.getCause());
    					e.getCause().printStackTrace();
    				} catch (DatabaseException e) {
                        procedure.exception(graph, e);
    					e.printStackTrace();
    				} catch (Throwable t) {
    				    procedure.exception(graph, t);
    				    t.printStackTrace();
    				}
                }
                
                @Override
                public String toString() {
                	return "ReflectionAdapter$1" + constructor + "$" + Arrays.toString(parameters);
                }
                
            });
        
    	}
        
    }
    
    @Override
    public String toString() {
        return "ReflectionAdapter for " + constructor.getName();
    }

}
