package fi.vtt.simantics.procore.internal;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncProcedure;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncProcedure;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterI.ClusterTypeEnum;
import org.simantics.db.impl.ForEachObjectContextProcedure;
import org.simantics.db.impl.ForEachObjectProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueContextProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueProcedure;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.TransientGraph;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.procedure.AsyncContextProcedure;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterSmall;
import org.simantics.db.procore.cluster.ResourceTableSmall;
import org.simantics.db.procore.cluster.ValueTableSmall;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.service.DirectQuerySupport;

public class DirectQuerySupportImpl implements DirectQuerySupport {

	final private SessionImplSocket session;
	
	DirectQuerySupportImpl(SessionImplSocket session) {
		this.session = session;
	}

	@Override
	final public void forEachDirectPersistentStatement(AsyncReadGraph graph, final Resource subject, final AsyncProcedure<DirectStatements> procedure) {
		ReadGraphImpl impl = (ReadGraphImpl)graph;
		impl.processor.forEachDirectStatement(impl, subject, procedure, true);
	}

	@Override
	final public void forEachDirectStatement(AsyncReadGraph graph, final Resource subject, final AsyncProcedure<DirectStatements> procedure) {
		ReadGraphImpl impl = (ReadGraphImpl)graph;
		impl.processor.forEachDirectStatement(impl, subject, procedure, false);
	}

	@Override
	public void forEachDirectStatement(AsyncReadGraph graph, Resource subject, SyncProcedure<DirectStatements> procedure) {
		forEachDirectStatement(graph, subject, new SyncToAsyncProcedure<DirectStatements>(procedure));
	}

	@Override
	public void forEachDirectStatement(AsyncReadGraph graph, Resource subject, Procedure<DirectStatements> procedure) {
		ReadGraphImpl impl = (ReadGraphImpl)graph;
		impl.processor.forEachDirectStatement(impl, subject, procedure);
	}

	@Override
	public void forRelationInfo(AsyncReadGraph graph, Resource subject, AsyncProcedure<RelationInfo> procedure) {
		ReadGraphImpl impl = (ReadGraphImpl)graph;
		impl.processor.forRelationInfo(impl, subject, procedure);
	}

	@Override
	public void forRelationInfo(AsyncReadGraph graph, Resource subject, SyncProcedure<RelationInfo> procedure) {
		forRelationInfo(graph, subject, new SyncToAsyncProcedure<RelationInfo>(procedure));
	}

	@Override
	public void forRelationInfo(AsyncReadGraph graph, Resource subject, Procedure<RelationInfo> procedure) {
		forRelationInfo(graph, subject, new NoneToAsyncProcedure<RelationInfo>(procedure));
	}

	@Override
	public AsyncMultiProcedure<Resource> compileForEachObject(ReadGraph graph, final Resource relation, AsyncMultiProcedure<Resource> user) {
		
		try {
			RelationInfo info = graph.syncRequest(new AsyncRead<RelationInfo>() {

				@Override
				public void perform(AsyncReadGraph graph, AsyncProcedure<RelationInfo> procedure) {
					forRelationInfo(graph, relation, procedure);
				}

                @Override
    		    public int threadHash() {
    		    	return hashCode();
    		    }

				@Override
				public int getFlags() {
					return 0;
				}

			});
	        final int predicateKey = ((ResourceImpl)relation).id;
			return new ForEachObjectProcedure(predicateKey, info, session.queryProvider2, user);
		} catch (DatabaseException e) {
			return null;
		}		
        
	}

	@Override
	public <C> AsyncContextMultiProcedure<C, Resource> compileForEachObject(ReadGraph graph, final Resource relation, AsyncContextMultiProcedure<C, Resource> user) {
		
		try {
			RelationInfo info = graph.syncRequest(new AsyncRead<RelationInfo>() {

				@Override
				public void perform(AsyncReadGraph graph, AsyncProcedure<RelationInfo> procedure) {
					forRelationInfo(graph, relation, procedure);
				}

                @Override
    		    public int threadHash() {
    		    	return hashCode();
    		    }

				@Override
				public int getFlags() {
					return 0;
				}

			});
	        final int predicateKey = ((ResourceImpl)relation).id;
			return new ForEachObjectContextProcedure<C>(predicateKey, info, session.queryProvider2, user);
		} catch (DatabaseException e) {
			return null;
		}		
        
	}
	
	@Override
	public <T> AsyncProcedure<T> compilePossibleRelatedValue(ReadGraph graph, final Resource relation, AsyncProcedure<T> user) {
		
		try {
			RelationInfo info = graph.syncRequest(new AsyncRead<RelationInfo>() {

				@Override
				public void perform(AsyncReadGraph graph, AsyncProcedure<RelationInfo> procedure) {
					forRelationInfo(graph, relation, procedure);
				}

                @Override
    		    public int threadHash() {
    		    	return hashCode();
    		    }

				@Override
				public int getFlags() {
					return 0;
				}

			});
	        final int predicateKey = ((ResourceImpl)relation).id;
			return new ForPossibleRelatedValueProcedure<T>(predicateKey, info, user);
		} catch (DatabaseException e) {
			return null;
		}		
        
	}

	@Override
	public <C, T> AsyncContextProcedure<C, T> compilePossibleRelatedValue(ReadGraph graph, final Resource relation, AsyncContextProcedure<C, T> user) {
		
		try {
			RelationInfo info = graph.syncRequest(new AsyncRead<RelationInfo>() {

				@Override
				public void perform(AsyncReadGraph graph, AsyncProcedure<RelationInfo> procedure) {
					forRelationInfo(graph, relation, procedure);
				}

                @Override
    		    public int threadHash() {
    		    	return hashCode();
    		    }

				@Override
				public int getFlags() {
					return 0;
				}

			});
	        final int predicateKey = ((ResourceImpl)relation).id;
			return new ForPossibleRelatedValueContextProcedure<C, T>(predicateKey, info, user);
		} catch (DatabaseException e) {
			return null;
		}		
        
	}
	
	@Override
	public void forEachObjectCompiled(AsyncReadGraph graph, Resource subject, final AsyncMultiProcedure<Resource> procedure) {
		
        assert(subject != null);
        
        final ForEachObjectProcedure proc = (ForEachObjectProcedure)procedure;
//        final RelationInfo info = proc.info;

        final ReadGraphImpl impl = (ReadGraphImpl)graph;
        final int subjectId = ((ResourceImpl)subject).id;

//        int callerThread = impl.callerThread;
//        int suggestSchedule = (subjectId>>16) & queryProvider2.THREAD_MASK;
        
//        impl.inc();
        
//        if(callerThread == suggestSchedule) {
        	
//        	if(info.isFunctional) {
//        		querySupport.getObjects4(impl, subjectId, proc);
//        	} else {
        	session.querySupport.getObjects4(impl, subjectId, proc);
//        	}
        	
//        } else {
//        	
//        	impl.state.barrier.inc();
//            impl.state.barrier.dec(callerThread);
//        	
//        	queryProvider2.schedule(callerThread, new SessionTask(suggestSchedule) {
//	
//	        	@Override
//	        	public void run(int thread) {
//	        		
//	            	impl.state.barrier.inc(thread);
//	        		impl.state.barrier.dec();
//
//	            	if(info.isFunctional) {
//	            		querySupport.getObjects4(impl.newAsync(thread), subjectId, proc);
//	            	} else {
//	            		querySupport.getObjects4(impl.newAsync(thread), subjectId, proc);
//	            	}
//	        		
//	        	}
//	        	
//	        	@Override
//	        	public String toString() {
//	        		return "gaff8";
//	        	}
//	
//	        });
//	        
//        }
		
	}

	@Override
	public <C> void forEachObjectCompiled(AsyncReadGraph graph, Resource subject, C context, final AsyncContextMultiProcedure<C, Resource> procedure) {
		
		assert(subject != null);

		final ForEachObjectContextProcedure<C> proc = (ForEachObjectContextProcedure<C>)procedure;
		final RelationInfo info = proc.info;

		final ReadGraphImpl impl = (ReadGraphImpl)graph;
		final int subjectId = ((ResourceImpl)subject).id;

//		int callerThread = impl.callerThread;
//		int suggestSchedule = (subjectId>>16) & queryProvider2.THREAD_MASK;

//		impl.inc();

		if(info.isFunctional) {
			session.querySupport.getObjects4(impl, subjectId, context, proc);
		} else {
			session.querySupport.getObjects4(impl, subjectId, context, proc);
		}
		
	}
	
	@Override
	public <T> void forPossibleRelatedValueCompiled(AsyncReadGraph graph, Resource subject, final AsyncProcedure<T> procedure) {
		
		assert(subject != null);

        final ForPossibleRelatedValueProcedure<T> proc = (ForPossibleRelatedValueProcedure<T>)procedure;
        final RelationInfo info = proc.info;
        
        final ReadGraphImpl impl = (ReadGraphImpl)graph;
        final int subjectId = ((ResourceImpl)subject).id;
        
//        int callerThread = impl.callerThread;
//        int suggestSchedule = (subjectId>>16) & session.queryProvider2.THREAD_MASK;
        
//        impl.inc();
        
//        if(callerThread == suggestSchedule) {
        	
        	if(info.isFunctional) {
        		getRelatedValue4(impl, subjectId, proc);
        	} else {
        		getRelatedValue4(impl, subjectId, proc);
        	}
        	
//        } else {
//        	
//        	impl.state.barrier.inc();
//            impl.state.barrier.dec(callerThread);
//        	
//        	queryProvider2.schedule(callerThread, new SessionTask(suggestSchedule) {
//	
//	        	@Override
//	        	public void run(int thread) {
//
//	                impl.state.barrier.inc(thread);
//	            	impl.state.barrier.dec();
//	        		
//	            	if(info.isFunctional) {
//	            		getRelatedValue4(impl.newAsync(thread), subjectId, proc);
//	            	} else {
//	            		getRelatedValue4(impl.newAsync(thread), subjectId, proc);
//	            	}
//	        		
//	        	}
//	        	
//	        	@Override
//	        	public String toString() {
//	        		return "gaff11";
//	        	}
//	
//	        });
//	        
//        }
		
	}

	@Override
	public <C, T> void forPossibleRelatedValueCompiled(AsyncReadGraph graph, Resource subject, C context, final AsyncContextProcedure<C, T> procedure) {
		
		assert(subject != null);

        final ForPossibleRelatedValueContextProcedure<C, T> proc = (ForPossibleRelatedValueContextProcedure<C, T>)procedure;
        final RelationInfo info = proc.info;
        
        final ReadGraphImpl impl = (ReadGraphImpl)graph;
        final int subjectId = ((ResourceImpl)subject).id;
        
//        int callerThread = impl.callerThread;
//        int suggestSchedule = (subjectId>>16) & session.queryProvider2.THREAD_MASK;
        
//        impl.inc();
        	
        if(info.isFunctional) {
        	getRelatedValue4(impl, subjectId, context, proc);
        } else {
        	getRelatedValue4(impl, subjectId, context, proc);
        }
		
	}
	
	@Override
	public <T> void forPossibleType(final AsyncReadGraph graph, Resource subject, final AsyncProcedure<Resource> procedure) {
		
        assert(subject != null);

        final ReadGraphImpl impl = (ReadGraphImpl)graph;
        final int subjectId = ((ResourceImpl)subject).id;

        try {
        	
	        final ClusterI cluster = session.clusterTable.getClusterByResourceKey(subjectId);
	        if(!cluster.isLoaded()) {

//	        	impl.state.inc(0);
	        	
	        	session.queryProvider2.requestCluster(impl, cluster.getClusterId(), new Runnable() {
		
					@Override
					public void run() {

				        try {

							int result = cluster.getCompleteObjectKey(subjectId, session.clusterTranslator);
					    	procedure.execute(graph, new ResourceImpl(session.resourceSupport, result));

//				        	impl.state.dec(0);						
					    	
				        } catch (DatabaseException e) {
				        	e.printStackTrace();
				        }
		
					}
		
				});
				
	        } else {

		    	int result = cluster.getCompleteObjectKey(subjectId, session.clusterTranslator);
		    	procedure.execute(graph, new ResourceImpl(session.resourceSupport, result));
	        	
	        }
	        
        } catch (DatabaseException e) {
        	e.printStackTrace();
        }
    	
    	
		
	}

	@Override
	public <C> void forPossibleDirectType(final AsyncReadGraph graph, Resource subject, final C context, final AsyncContextProcedure<C, Resource> procedure) {
		
        assert(subject != null);

        final ReadGraphImpl impl = (ReadGraphImpl)graph;
        final int subjectId = ((ResourceImpl)subject).id;
        
        try {
        	
	        final ClusterI cluster = session.clusterTable.getClusterByResourceKey(subjectId);
	        if(!cluster.isLoaded()) {

//	        	impl.state.inc(0);
	        	
	        	session.queryProvider2.requestCluster(impl, cluster.getClusterId(), new Runnable() {
		
					@Override
					public void run() {

				        try {

			        		ClusterI.CompleteTypeEnum type = cluster.getCompleteType(subjectId, session.clusterTranslator);
			        		if(ClusterI.CompleteTypeEnum.InstanceOf == type) {
						    	int result = cluster.getCompleteObjectKey(subjectId, session.clusterTranslator);
						    	procedure.execute(graph, context, new ResourceImpl(session.resourceSupport, result));
			        		} else {
			                	procedure.execute(graph, context, null);
			        		}

//				        	impl.state.dec(0);
					    	
				        } catch (DatabaseException e) {
				        	e.printStackTrace();
				        }
		
					}
		
				});
				
	        } else {

        		ClusterI.CompleteTypeEnum type = cluster.getCompleteType(subjectId, session.clusterTranslator);
        		if(ClusterI.CompleteTypeEnum.InstanceOf == type) {
			    	int result = cluster.getCompleteObjectKey(subjectId, session.clusterTranslator);
			    	procedure.execute(graph, context, new ResourceImpl(session.resourceSupport, result));
        		} else {
                	procedure.execute(graph, context, null);
        		}
	        	
	        }
	        
        } catch (DatabaseException e) {
        	
        	procedure.execute(graph, context, null);
        	
        } catch (Throwable t) {

        	t.printStackTrace();
        	procedure.execute(graph, context, null);
        	
        }
		
	}
	
	
	private <C, T> void getRelatedValue4(final ReadGraphImpl graph, final int subject, final C context, final ForPossibleRelatedValueContextProcedure<C, T> procedure) {
		
		int result = 0;
		
		final int predicate = procedure.predicateKey;

		if(subject < 0) {

			if(!SessionImplSocket.areVirtualStatementsLoaded(session.virtualGraphServerSupport, subject, predicate)) {
			    SessionImplSocket.loadVirtualStatements(session.virtualGraphServerSupport, graph, subject, predicate,
			            g -> getRelatedValue4(g, subject, context, procedure)
				);
				return;
			}
			
			for(TransientGraph g : session.virtualGraphServerSupport.providers) {
                for (int id : g.getObjects(subject, predicate)) {
                	if(result != 0) {
                		procedure.exception(graph, new DatabaseException("Multiple objects"));
//                		graph.dec();
                		return;
                	} else {
                		result = id;
                	}
                }
			}
			
			if(result == 0) {
				
        		procedure.exception(graph, new DatabaseException("No objects for " + subject ));
//        		graph.dec();
        		return;
        		
			} else {
				
				getValue4(graph, null, result, context, procedure);
				return;
				
			}
			
		} 
		
        final org.simantics.db.procore.cluster.ClusterImpl cluster = session.clusterTable.getClusterByResourceKey(subject);
        if(!cluster.isLoaded()) {
        	cluster.load(session.clusterTranslator, () -> getRelatedValue4(graph, subject, context, procedure));
        	return;
        }
        
        if(cluster.hasVirtual() && session.virtualGraphServerSupport.virtuals.contains(subject)) {
			
			if(!SessionImplSocket.areVirtualStatementsLoaded(session.virtualGraphServerSupport, subject, predicate)) {
			    SessionImplSocket.loadVirtualStatements(session.virtualGraphServerSupport, graph, subject, predicate,
			            g -> getRelatedValue4(g, subject, context, procedure)
				);
				return;
			}
        	
			for(TransientGraph g : session.virtualGraphServerSupport.providers) {
                for (int id : g.getObjects(subject, predicate)) {
                	if(result != 0) {
                		procedure.exception(graph, new DatabaseException("Multiple objects"));
//                		graph.dec();
                		return;
                	} else {
                		result = id;
                	}
                }
			}
			
			getRelatedDirectValue4(graph, cluster, subject, result, context, procedure);
			
		} else {
			
			getRelatedDirectValue4(graph, cluster, subject, 0, context, procedure);
			
		}
		
	}
	
	private <T> void getValue4(final ReadGraphImpl graph, final ClusterImpl containerCluster, final int subject, final ForPossibleRelatedValueProcedure<T> procedure) {
		
		Object result = null;
	
		if(subject < 0) {

			if(!SessionImplSocket.areVirtualStatementsLoaded(session.virtualGraphServerSupport, subject)) {
			    SessionImplSocket.loadVirtualStatements(session.virtualGraphServerSupport, graph, subject, 
			            g -> getValue4(g, containerCluster, subject, procedure)
			    );
				return;
			}
			
			for(TransientGraph g : session.virtualGraphServerSupport.providers) {
				Object value = g.getValue(subject);
				if(value != null) {
					if(result != null) {
						procedure.exception(graph, new DatabaseException("Multiple values"));
//						graph.dec();
						return;
					} else {
						result = value;
					}
				}
			}

			procedure.execute(graph, (T)"name");
//			graph.dec();
			return;

		}
		
		ClusterImpl cluster = containerCluster;
		if(!containerCluster.contains(subject)) {
			cluster = session.clusterTable.getClusterByResourceKey(subject);
			if(!cluster.isLoaded()) {
				cluster.load(session.clusterTranslator, new Runnable() {

					@Override
					public void run() {
						getValue4(graph, containerCluster, subject, procedure);
					}

				});
				return;
			}
		}
		
        if(cluster.hasVirtual() && session.virtualGraphServerSupport.virtuals.contains(subject)) {

			if(!SessionImplSocket.areVirtualStatementsLoaded(session.virtualGraphServerSupport, subject)) {
			    SessionImplSocket.loadVirtualStatements(session.virtualGraphServerSupport, graph, subject,
			    g -> getValue4(g, containerCluster, subject, procedure)
			    );
				return;
			}
        	
			for(TransientGraph g : session.virtualGraphServerSupport.providers) {
				Object value = g.getValue(subject);
				if(value != null) {
					if(result != null) {
						procedure.exception(graph, new DatabaseException("Multiple values"));
//						graph.dec();
						return;
					} else {
						result = value;
					}
				}
			}
			
			if(result != null) {
				
				procedure.execute(graph, (T)result);
//				graph.state.barrier.dec();
				
			} else {
				
				if(ClusterTypeEnum.SMALL == cluster.getType())
					getDirectValue4(graph, (ClusterSmall)cluster, subject, procedure);
				else 
					getDirectValue4(graph, (ClusterBig)cluster, subject, procedure);
			}

		} else {

			if(ClusterTypeEnum.SMALL == cluster.getType())
				getDirectValue4(graph, (ClusterSmall)cluster, subject, procedure);
			else 
				getDirectValue4(graph, (ClusterBig)cluster, subject, procedure);

		}
	
	}
	
	private <C, T> void getValue4(final ReadGraphImpl graph, final ClusterImpl containerCluster, final int subject, final C context, final ForPossibleRelatedValueContextProcedure<C, T> procedure) {
		
		Object result = null;
	
		if(subject < 0) {

			if(!SessionImplSocket.areVirtualStatementsLoaded(session.virtualGraphServerSupport, subject)) {
			    SessionImplSocket.loadVirtualStatements(session.virtualGraphServerSupport, graph, subject,
			            g -> getValue4(g, containerCluster, subject, context, procedure)
			    );
				return;
			}
			
			for(TransientGraph g : session.virtualGraphServerSupport.providers) {
				Object value = g.getValue(subject);
				if(value != null) {
					if(result != null) {
						procedure.exception(graph, new DatabaseException("Multiple values"));
//						graph.dec();
						return;
					} else {
						result = value;
					}
				}
			}

			procedure.execute(graph, context, (T)"name");
//			graph.dec();
			return;

		}
		
		ClusterImpl cluster = containerCluster;
		if(!containerCluster.contains(subject)) {
			cluster = session.clusterTable.getClusterByResourceKey(subject);
			if(!cluster.isLoaded()) {
				cluster.load(session.clusterTranslator, new Runnable() {

					@Override
					public void run() {
						getValue4(graph, containerCluster, subject, context, procedure);
					}

				});
				return;
			}
		}
		
        if(cluster.hasVirtual() && session.virtualGraphServerSupport.virtuals.contains(subject)) {

			if(!SessionImplSocket.areVirtualStatementsLoaded(session.virtualGraphServerSupport, subject)) {
			    SessionImplSocket.loadVirtualStatements(session.virtualGraphServerSupport, graph, subject,
			             g -> getValue4(g, containerCluster, subject, context, procedure)
			    );
				return;
			}
        	
			for(TransientGraph g : session.virtualGraphServerSupport.providers) {
				Object value = g.getValue(subject);
				if(value != null) {
					if(result != null) {
						procedure.exception(graph, new DatabaseException("Multiple values"));
//						graph.dec();
						return;
					} else {
						result = value;
					}
				}
			}
			
			if(result != null) {
				
				procedure.execute(graph, context, (T)result);
//				graph.state.barrier.dec();
				
			} else {
				
				if(ClusterTypeEnum.SMALL == cluster.getType())
					getDirectValue4(graph, (ClusterSmall)cluster, subject, context, procedure);
				else 
					getDirectValue4(graph, (ClusterBig)cluster, subject, context, procedure);
			}

		} else {

			if(ClusterTypeEnum.SMALL == cluster.getType())
				getDirectValue4(graph, (ClusterSmall)cluster, subject, context, procedure);
			else 
				getDirectValue4(graph, (ClusterBig)cluster, subject, context, procedure);

		}
	
	}

	private <T> void getRelatedDirectValue4(final ReadGraphImpl graph, final ClusterImpl cluster, final int subject, final int result, final ForPossibleRelatedValueProcedure<T> procedure) {

		try {

			int so = cluster.getSingleObject(subject, procedure, session.clusterTranslator);
			if(so == 0) {
				if(result == 0) {
					procedure.exception(graph, new DatabaseException("No objects " + subject + " " + procedure.predicateKey));
//					graph.dec();
				} else {
					getValue4(graph, cluster, result, procedure);
				}
			} else {
				if(result == 0) {
					getValue4(graph, cluster, so, procedure);
				} else {
					procedure.exception(graph, new DatabaseException("Multiple objects"));
//					graph.dec();
				}
			}

		} catch (DatabaseException e) {
			e.printStackTrace();
		}
		
	}

	private <C, T> void getRelatedDirectValue4(final ReadGraphImpl graph, final ClusterImpl cluster, final int subject, final int result, final C context, final ForPossibleRelatedValueContextProcedure<C, T> procedure) {

		try {

			int so = cluster.getSingleObject(subject, procedure, session.clusterTranslator);
			if(so == 0) {
				if(result == 0) {
					procedure.exception(graph, new DatabaseException("No objects " + subject + " " + procedure.predicateKey));
//					graph.dec();
				} else {
					getValue4(graph, cluster, result, context, procedure);
				}
			} else {
				if(result == 0) {
					getValue4(graph, cluster, so, context, procedure);
				} else {
					procedure.exception(graph, new DatabaseException("Multiple objects"));
//					graph.dec();
				}
			}

		} catch (DatabaseException e) {
			e.printStackTrace();
		}
		
	}
	
	public <T> void getRelatedValue4(final ReadGraphImpl graph, final int subject, final ForPossibleRelatedValueProcedure<T> procedure) {
		
		int result = 0;
		
		final int predicate = procedure.predicateKey;

		if(subject < 0) {

			if(!SessionImplSocket.areVirtualStatementsLoaded(session.virtualGraphServerSupport, subject, predicate)) {
			    SessionImplSocket.loadVirtualStatements(session.virtualGraphServerSupport, graph, subject, predicate,
			            g -> getRelatedValue4(g, subject, procedure)
			    );
				return;
			}
			
			for(TransientGraph g : session.virtualGraphServerSupport.providers) {
                for (int id : g.getObjects(subject, predicate)) {
                	if(result != 0) {
                		procedure.exception(graph, new DatabaseException("Multiple objects"));
//                		graph.dec();
                		return;
                	} else {
                		result = id;
                	}
                }
			}
			
			if(result == 0) {
				
        		procedure.exception(graph, new DatabaseException("No objects for " + subject ));
//        		graph.dec();
        		return;
        		
			} else {
				
				getValue4(graph, null, result, procedure);
				return;
				
			}
			
		} 
		
        final org.simantics.db.procore.cluster.ClusterImpl cluster = session.clusterTable.getClusterByResourceKey(subject);
        if(!cluster.isLoaded()) {
        	cluster.load(session.clusterTranslator, new Runnable() {

				@Override
				public void run() {
					getRelatedValue4(graph, subject, procedure);
				}
        		
        	});
        	return;
        }
        
        if(cluster.hasVirtual() && session.virtualGraphServerSupport.virtuals.contains(subject)) {
			
			if(!SessionImplSocket.areVirtualStatementsLoaded(session.virtualGraphServerSupport, subject, predicate)) {
			    SessionImplSocket.loadVirtualStatements(session.virtualGraphServerSupport, graph, subject, predicate,
			            g -> getRelatedValue4(graph, subject, procedure)
			    );
				return;
			}
        	
			for(TransientGraph g : session.virtualGraphServerSupport.providers) {
                for (int id : g.getObjects(subject, predicate)) {
                	if(result != 0) {
                		procedure.exception(graph, new DatabaseException("Multiple objects"));
//                		graph.dec();
                		return;
                	} else {
                		result = id;
                	}
                }
			}
			
			getRelatedDirectValue4(graph, cluster, subject, result, procedure);
			
		} else {
			
			getRelatedDirectValue4(graph, cluster, subject, 0, procedure);
			
		}
		
	}
	
	private <C, T> void getDirectValue4(final ReadGraphImpl graph, final ClusterSmall cluster, final int subject, final C context, final ForPossibleRelatedValueContextProcedure<C, T> procedure) {
		
		try {
			byte[] bytes = cluster.getValue(subject, session.clusterTranslator);
			T value = (T)utf(bytes);
			procedure.execute(graph, context, value);
		} catch (DatabaseException e) {
			procedure.execute(graph, context, null);
		}

//		graph.dec();
		
	}

	private <T> void getDirectValue4(final ReadGraphImpl graph, final ClusterBig cluster, final int subject, final ForPossibleRelatedValueProcedure<T> procedure) {
		
		try {
			byte[] bytes = cluster.getValue(subject, session.clusterTranslator);
			T value = (T)utf(bytes);
			procedure.execute(graph, value);
		} catch (DatabaseException e) {
			procedure.execute(graph, null);
		}

//		graph.dec();
		
	}

	private <C, T> void getDirectValue4(final ReadGraphImpl graph, final ClusterBig cluster, final int subject, final C context, final ForPossibleRelatedValueContextProcedure<C, T> procedure) {
		
		try {
			byte[] bytes = cluster.getValue(subject, session.clusterTranslator);
			if(bytes == null) {
				procedure.execute(graph, context, null);
			} else {
				T value = (T)utf(bytes);
				procedure.execute(graph, context, value);
			}
		} catch (DatabaseException e) {
			procedure.execute(graph, context, null);
		}

//		graph.dec();
		
	}
	
	private final char[] chars = new char[1024];
	
	private <T> void getDirectValue4(final ReadGraphImpl graph, final ClusterSmall cluster, final int subject, final ForPossibleRelatedValueProcedure<T> procedure) {

		ResourceTableSmall rt = cluster.resourceTable;
		ValueTableSmall vt = cluster.valueTable;

		byte[] bs = vt.table;
		long[] ls = rt.table;

		int index = ((subject&0xFFFF) << 1) - 1 + rt.offset;

		int valueIndex = (int)(ls[index] >>> 24) & 0x3FFFFF + vt.offset;

		int size = (int)bs[valueIndex++]-1;
		valueIndex++;
		for(int i=0;i<size;i++) {
			chars[i] = (char)bs[valueIndex++];
		}

		T value = (T)new String(chars, 0, size);

		procedure.execute(graph, value);
//		graph.dec();
		
	}

	final private String utf(byte[] bytes) {
		
		if(bytes == null) return null;
		
		int index = 0;
		int length = bytes[index++]&0xff; 
		if(length >= 0x80) {
			if(length >= 0xc0) {
				if(length >= 0xe0) {
					if(length >= 0xf0) {
						length &= 0x0f;
						length += ((bytes[index++]&0xff)<<3);
						length += ((bytes[index++]&0xff)<<11);
						length += ((bytes[index++]&0xff)<<19);
						length += 0x10204080;
					}
					else {
						length &= 0x1f;
						length += ((bytes[index++]&0xff)<<4);
						length += ((bytes[index++]&0xff)<<12);
						length += ((bytes[index++]&0xff)<<20);
						length += 0x204080;
					}
				}
				else {
					length &= 0x3f;
					length += ((bytes[index++]&0xff)<<5);
					length += ((bytes[index++]&0xff)<<13);
					length += 0x4080;
				}
			}
			else {
				length &= 0x7f;
				length += ((bytes[index++]&0xff)<<6);
				length += 0x80;
			}
		}
		
		int i = 0;
		int target = length+index;
		while(index < target) {
			int c = bytes[index++]&0xff;
			if(c <= 0x7F) {
				chars[i++] = (char)(c&0x7F);
			} else if (c > 0x07FF) {
				int c2 = bytes[index++]&0xff;
				int c3 = bytes[index++]&0xff;
				chars[i++] = (char)(((c&0xf)<<12) + ((c2&0x3f)<<6) + (c3&0x3f)); 
			} else {
				int c2 = bytes[index++]&0xff;
				chars[i++] = (char)(((c&0x1f)<<6) + (c2&0x3f)); 
			}
			
			
//			if (!((c >= 0x0001) && (c <= 0x007F))) {
//			} else {
//			}
//			
//				if ((c >= 0x0001) && (c <= 0x007F)) {
//					bytearr[byteIndex++] = (byte)( c );
//				} else if (c > 0x07FF) {
//					bytearr[byteIndex++] = (byte)(0xE0 | ((c >> 12) & 0x0F));
//					bytearr[byteIndex++] = (byte)(0x80 | ((c >>  6) & 0x3F));
//					bytearr[byteIndex++] = (byte)(0x80 | ((c >>  0) & 0x3F));
//				} else {
//					bytearr[byteIndex++] = (byte)(0xC0 | ((c >>  6) & 0x1F));
//					bytearr[byteIndex++] = (byte)(0x80 | ((c >>  0) & 0x3F));
//				}
//			}
			
			
		}
		return new String(chars, 0, i);
	}
	
}
