package fi.vtt.simantics.procore.internal;

import java.util.Arrays;

import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ClusterUID;

class ClusterChange2 {
    public static final int VERSION = 2;
    public static final byte SET_IMMUTABLE_OPERATION = 1; // <byte : 0 = false>
    public static final byte UNDO_VALUE_OPERATION = 2; // <int : resource index>
    public static final byte SET_DELETED_OPERATION = 3; // <byte : 0 = false>
    private static final int INCREMENT = 1<<10;
    private boolean dirty = false;
    private byte[] bytes;
    private int byteIndex;
    private ClusterUID clusterUID;
    ClusterChange2(ClusterUID clusterUID, ClusterImpl cluster) {
        this.clusterUID = clusterUID;
        init();
    }
    void init() {
//        System.err.println("clusterChange2 dirty " + cluster.clusterId);
        dirty = false;
        bytes = new byte[INCREMENT];
        byteIndex = 0;
        addInt(0); // Size of byte vector. Set by flush.
        addInt(VERSION);
        byteIndex = clusterUID.toByte(bytes, 8);
    }
    boolean isDirty() {
        return dirty;
    }
    void flush(GraphSession graphSession) {
//        System.err.println("flush2 clusterChange2 " + dirty + this);
        if (!dirty)
            return;
        Bytes.writeLE(bytes, 0, byteIndex - 4);
        byte[] ops = Arrays.copyOf(bytes, byteIndex);
//        System.err.println("flush2 clusterChange2 " + cluster.clusterId + " " + ops.length + " bytes.");
        graphSession.updateCluster(new UpdateClusterFunction(ops));
        init();
    }
    void setImmutable(boolean immutable) {
        dirty = true;
        addByte(SET_IMMUTABLE_OPERATION);
        addByte((byte)(immutable ? -1 : 0));
    }
    void setDeleted(boolean deleted) {
        dirty = true;
        addByte(SET_DELETED_OPERATION);
        addByte((byte)(deleted ? -1 : 0));
    }
    void undoValueEx(int resourceIndex) {
        dirty = true;
        addByte(UNDO_VALUE_OPERATION);
        addInt(resourceIndex);
    }
    private final void checkSpace(int len) {
        if (bytes.length - byteIndex > len)
            return;
       bytes = Arrays.copyOf(bytes, bytes.length + len + INCREMENT);
    }
    private final void addByte(byte value) {
        checkSpace(1);
        bytes[byteIndex++] = value;
    }
    private final void addInt(int value) {
        checkSpace(4);
        Bytes.writeLE(bytes, byteIndex, value);
        byteIndex += 4;
    }
}
