/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.impl.hash.THash;
import java.lang.reflect.Array;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.BinaryQuery;
import org.simantics.db.impl.query.QueryProcessor;

public abstract class BinaryQueryHash<Procedure>
extends THash {
    static final long serialVersionUID = -3461112548087185871L;
    protected transient BinaryQuery<Procedure>[] _set;
    protected final BinaryQuery<Procedure> REMOVED = new BinaryQuery<Procedure>(-1L, -1L){

        @Override
        public void computeForEach(ReadGraphImpl graph, QueryProcessor provider, Object procedure, boolean store) {
            throw new Error("Not possible!");
        }

        @Override
        public void putEntry(QueryProcessor provider) {
            throw new Error("Not possible!");
        }

        @Override
        public BinaryQuery<Procedure> getEntry(QueryProcessor provider) {
            throw new Error("Not possible!");
        }

        @Override
        public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
            throw new Error("Not possible!");
        }

        @Override
        public void removeEntry(QueryProcessor provider) {
            throw new Error("Not possible!");
        }

        @Override
        public int type() {
            throw new Error("Not possible!");
        }

        @Override
        public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, Procedure procedure) {
            throw new Error("Not possible!");
        }

        @Override
        public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
            throw new Error("Not possible!");
        }
    };

    public BinaryQueryHash() {
        super(10, 0.75f);
    }

    public int capacity() {
        return this._set.length;
    }

    protected void removeAt(int index) {
        this._set[index] = this.REMOVED;
        super.removeAt(index);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = (BinaryQuery[])Array.newInstance(BinaryQuery.class, capacity);
        return capacity;
    }

    protected final int index(long id) {
        BinaryQuery<Procedure>[] set = this._set;
        int hash = 31 * (int)(id >>> 32) + (int)id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        BinaryQuery<Procedure> cur = set[index];
        if (cur == null) {
            return -1;
        }
        if (cur == this.REMOVED || id != cur.id) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || id != cur.id));
        }
        return cur == null ? -1 : index;
    }

    protected final int insertionIndex(long id) {
        BinaryQuery<Procedure>[] set = this._set;
        int hash = 31 * (int)(id >>> 32) + (int)id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        BinaryQuery<Procedure> cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && id == cur.id) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && id != cur.id);
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || id != cur.id)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + " object #1 hash = " + o1.hashCode() + " object #1 id = " + System.identityHashCode(o1) + "; object #2 =" + o2 + " object #2 hash = " + o2.hashCode() + " object #2 id = " + System.identityHashCode(o2));
    }
}

