/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal;

import java.net.URI;
import java.util.concurrent.Semaphore;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Activator;
import org.eclipse.userstorage.internal.StorageServiceRegistry;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.spi.ICredentialsProvider;

public class StorageService
implements IStorageService {
    private static final String TERMS_OF_USE_AGREED_KEY = "termsOfUseAgreed";
    private static final boolean QUIET_SECURE_STORAGE_EXCEPTION = Boolean.getBoolean("org.eclipse.userstorage.quietSecureStorageException");
    private final Semaphore authenticationSemaphore = new Semaphore(1);
    private final String serviceLabel;
    private final URI serviceURI;
    private final URI createAccountURI;
    private final URI editAccountURI;
    private final URI recoverPasswordURI;
    private final String termsOfUseLink;
    private ICredentialsProvider credentialsProvider;

    public StorageService(String serviceLabel, URI serviceURI, URI createAccountURI, URI editAccountURI, URI recoverPasswordURI, String termsOfUseLink) {
        if (StringUtil.isEmpty(serviceLabel)) {
            throw new IllegalArgumentException("Service label is null or empty");
        }
        if (serviceURI == null) {
            throw new IllegalArgumentException("Service URI is null");
        }
        this.serviceLabel = serviceLabel;
        this.serviceURI = serviceURI;
        this.createAccountURI = createAccountURI;
        this.editAccountURI = editAccountURI;
        this.recoverPasswordURI = recoverPasswordURI;
        this.termsOfUseLink = termsOfUseLink;
    }

    @Override
    public String getServiceLabel() {
        return this.serviceLabel;
    }

    @Override
    public URI getServiceURI() {
        return this.serviceURI;
    }

    @Override
    public URI getCreateAccountURI() {
        return this.createAccountURI;
    }

    @Override
    public URI getEditAccountURI() {
        return this.editAccountURI;
    }

    @Override
    public URI getRecoverPasswordURI() {
        return this.recoverPasswordURI;
    }

    @Override
    public String getTermsOfUseLink() {
        return this.termsOfUseLink;
    }

    @Override
    public Semaphore getAuthenticationSemaphore() {
        return this.authenticationSemaphore;
    }

    public Credentials getCredentials() {
        if (this.credentialsProvider == null) {
            return null;
        }
        return this.credentialsProvider.getCredentials(this);
    }

    public boolean setCredentials(Credentials credentials) {
        if (this.credentialsProvider == null) {
            return false;
        }
        return this.credentialsProvider.updateCredentials(this, credentials);
    }

    public boolean isTermsOfUseAgreed() {
        try {
            String value;
            ISecurePreferences securePreferences = this.getSecurePreferences();
            if (securePreferences != null && "true".equalsIgnoreCase(value = securePreferences.get(TERMS_OF_USE_AGREED_KEY, null))) {
                return true;
            }
        }
        catch (Exception ex) {
            StorageService.logSecureStorageProblem(ex);
        }
        return false;
    }

    public void setTermsOfUseAgreed(boolean agreed) {
        try {
            ISecurePreferences securePreferences = this.getSecurePreferences();
            if (securePreferences != null) {
                if (agreed) {
                    securePreferences.putBoolean(TERMS_OF_USE_AGREED_KEY, true, false);
                } else {
                    securePreferences.remove(TERMS_OF_USE_AGREED_KEY);
                }
                securePreferences.flush();
            }
        }
        catch (Exception ex) {
            StorageService.logSecureStorageProblem(ex);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.serviceURI == null ? 0 : this.serviceURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageService other = (StorageService)obj;
        return !(this.serviceURI == null ? other.serviceURI != null : !this.serviceURI.equals(other.serviceURI));
    }

    @Override
    public int compareTo(IStorageService o) {
        return this.serviceLabel.compareTo(o.getServiceLabel());
    }

    public String toString() {
        return this.serviceLabel;
    }

    public ISecurePreferences getSecurePreferences() {
        ISecurePreferences securePreferences = Activator.getSecurePreferences();
        if (securePreferences != null) {
            String serviceNode = StringUtil.encodeURI(this.serviceURI);
            return securePreferences.node(serviceNode);
        }
        return null;
    }

    ICredentialsProvider getCredentialsProvider() {
        if (this.credentialsProvider == null) {
            String property = System.getProperty("org.eclipse.userstorage.credentialsProvider", null);
            if (property != null) {
                try {
                    Class<?> c = Class.forName(property);
                    this.credentialsProvider = (ICredentialsProvider)c.newInstance();
                }
                catch (Throwable ex) {
                    Activator.log(ex);
                }
            }
            if (this.credentialsProvider == null) {
                this.credentialsProvider = Activator.getCredentialsProvider();
            }
        }
        return this.credentialsProvider;
    }

    private static void logSecureStorageProblem(Exception ex) {
        if (QUIET_SECURE_STORAGE_EXCEPTION && ex instanceof StorageException) {
            return;
        }
        Activator.log(ex);
    }

    public static final class DynamicService
    extends StorageService
    implements IStorageService.Dynamic {
        public DynamicService(String serviceLabel, URI serviceURI, URI createAccountURI, URI editAccountURI, URI recoverPasswordURI, String termsOfUseLink) {
            super(serviceLabel, serviceURI, createAccountURI, editAccountURI, recoverPasswordURI, termsOfUseLink);
        }

        @Override
        public void remove() {
            StorageServiceRegistry.INSTANCE.removeService(this);
            ISecurePreferences securePreferences = this.getSecurePreferences();
            if (securePreferences != null) {
                try {
                    ISecurePreferences parent = securePreferences.parent();
                    securePreferences.removeNode();
                    parent.flush();
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
        }
    }
}

