/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.wiki.ui.editor;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;

public class WikiExportPDFAction extends Action {

	final IExportable exportable;
	
	public WikiExportPDFAction(IExportable exportable) {
		this.exportable = exportable;
	}
	
	public void run() {
		
		Shell shell = Display.getCurrent().getActiveShell();

        FileDialog fd = new FileDialog(shell, SWT.SAVE);
        fd.setText("Save PDF");
        fd.setFilterPath("C:/");
        String[] filterExt = { "*.pdf", "*.*" };
        fd.setFilterExtensions(filterExt);
        String filename = fd.open();
        if (filename == null)
            return;
		exportPDF(filename);
		
	}
	
	protected void exportPDF(String filename) {		
		Document document = new Document(PageSize.A4,36,36,36,36);
		try {
			PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(filename));
			document.open();
			exportable.export(document, writer);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			document.close();
		}
	}
}
