package org.simantics.scl.compiler.parser.generator.table;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

import org.simantics.scl.compiler.parser.generator.compression.CompressedParseTable;
import org.simantics.scl.compiler.parser.generator.compression.ErrorTable;
import org.simantics.scl.compiler.parser.generator.compression.GCCompress;

public class ParseTable {
    public final int stateCount;
    public final int[][] actionTable;
    public final int[][] gotoTable;
    public final int[] productionInfo;
    public final int[] initialStates;
    public final String[] stateDescriptions;
    
    public ParseTable(
            int stateCount,
            int[][] actionTable,
            int[][] gotoTable,
            int[] productionInfo,
            int[] initialStates,
            String[] stateDescriptions) {
        this.stateCount = stateCount;
        this.actionTable = actionTable;
        this.gotoTable = gotoTable;
        this.productionInfo = productionInfo;
        this.initialStates = initialStates;
        this.stateDescriptions = stateDescriptions;
    }
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("productionInfo = ").append(Arrays.toString(productionInfo)).append('\n');
        b.append("actions:\n");
        for(int[] actions : actionTable) {
            b.append("    {");
            for(int i=0;i<actions.length;++i) {
                if(i > 0)
                    b.append(", ");
                b.append(actions[i]);
            }
            b.append("},\n");
        }
        b.append("gotos:\n");
        for(int[] gotos : gotoTable) {
            b.append("    {");
            for(int i=0;i<gotos.length;++i) {
                if(i > 0)
                    b.append(", ");
                b.append(gotos[i]);
            }
            b.append("},\n");
        }
        return b.toString();
    }
    
    public CompressedParseTable compress() {
        return new CompressedParseTable(
                GCCompress.compress(actionTable), 
                ErrorTable.createErrorTable(actionTable),
                GCCompress.compress(gotoTable),
                productionInfo,
                initialStates,
                stateDescriptions);
    }
    
    public void writeTo(File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        DataOutputStream output = new DataOutputStream(stream);
        for(int[] row : actionTable)
            for(int val : row)
                output.writeInt(val);
        for(int[] row : gotoTable)
            for(int val : row)
                output.writeInt(val);
        for(int val : productionInfo)
            output.writeInt(val);
        output.close();
    }
}
