package org.simantics.scl.compiler.module;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.modules.Documentation;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.top.ModuleInitializer;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.runtime.profiling.BranchPoint;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;

public interface Module {
    String getName();
    String getDefaultLocalName();
    
    SCLValue getValue(String name);
    List<Constant> getFieldAccessors(String name);
    SCLRelation getRelation(String name);
    SCLEntityType getEntityType(String name);
    
    TypeDescriptor getTypeDescriptor(String name);
    
    EffectConstructor getEffectConstructor(String name);
    TypeClass getTypeClass(String name);
    Collection<TypeClassInstance> getInstances(TCon typeClass);
    MappingRelation getMappingRelation(String name);
    TransformationRule getRule(String name);
    CHRRuleset getRuleset(String name);
    Collection<TransformationRule> getRules();
    
    void findValuesForPrefix(String prefix, NamespaceFilter filter, TObjectProcedure<SCLValue> proc);
    void findValuesForPrefix(String prefix, NamespaceFilter filter, Consumer<SCLValue> consumer);
    
    void findTypesForPrefix(String prefix, NamespaceFilter instance, Consumer<TCon> consumer);
    
    List<ImportDeclaration> getDependencies();
    Documentation getDocumentation();
    
    byte[] getClass(String name);
    ModuleInitializer getModuleInitializer();

    THashMap<String, BranchPoint[]> getBranchPoints();
    void dispose();

    CompilationError[] getWarnings();
    ClassLoader getParentClassLoader();
}
