package org.simantics.scl.compiler.module;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.modules.Documentation;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.top.ModuleInitializer;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.runtime.profiling.BranchPoint;

import gnu.trove.map.hash.THashMap;

public abstract class LazyModule implements Module {

    String moduleName;
    private THashMap<String, SCLValue> values = new THashMap<String, SCLValue>();
    private THashMap<String, SCLRelation> relations = new THashMap<String, SCLRelation>();
    private THashMap<String, SCLEntityType> entityTypes = new THashMap<String, SCLEntityType>();
    
    protected abstract SCLValue createValue(String name);
    
    protected SCLRelation createRelation(String name) {
        return null;
    }
    
    protected SCLEntityType createEntityType(String name) {
        return null;
    }
    
    @Override
    public MappingRelation getMappingRelation(String name) {
        return null;
    }
    
    @Override
    public TransformationRule getRule(String name) {
        return null;
    }
    
    public LazyModule(String moduleName) {
        this.moduleName = moduleName;
    }
        
    @Override
    public String getName() {
        return moduleName;
    }
    
    public void findValuesForPrefix(final Collection<SCLValue> values, final String prefix) {    	
    }

    @Override
    public SCLValue getValue(String name) {
        if(values.containsKey(name))
            return values.get(name);
        else {
            SCLValue value = createValue(name);
            values.put(name, value);
            return value;
        }
    }
    
    @Override
    public List<Constant> getFieldAccessors(String name) {
        return null;
    }
    
    public SCLRelation getRelation(String name) {
        if(relations.containsKey(name))
            return relations.get(name);
        else {
            SCLRelation relation = createRelation(name);
            relations.put(name, relation);
            return relation;
        }
    }
    
    public SCLEntityType getEntityType(String name) {
        if(entityTypes.containsKey(name))
            return entityTypes.get(name);
        else {
            SCLEntityType entityType = createEntityType(name);
            entityTypes.put(name, entityType);
            return entityType;
        }
    } 

    @Override
    public TypeClass getTypeClass(String name) {
        return null;
    }
   
    @Override
    public Collection<TypeClassInstance> getInstances(TCon typeClass) {
        return Collections.emptyList();
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name) {
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return null;
    }
    
    @Override
    public byte[] getClass(String name) {
        return null;
    }
    
    @Override
    public ModuleInitializer getModuleInitializer() {
        return null;
    }
    
    @Override
    public EffectConstructor getEffectConstructor(String name) {
        return null;
    }
    
    @Override
    public Collection<TransformationRule> getRules() {
        return Collections.emptyList();
    }
    
    @Override
    public THashMap<String, BranchPoint[]> getBranchPoints() {
        return null;
    }
    
    @Override
    public CompilationError[] getWarnings() {
        return CompilationError.EMPTY_ARRAY;
    }
    
    @Override
    public CHRRuleset getRuleset(String name) {
        return null;
    }
}
