package org.simantics.scl.compiler.internal.parsing.declarations;

import java.util.List;

import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.parsing.Token;

public class DAnnotationAst extends DeclarationAst {
    public static final DAnnotationAst[] EMPTY_ARRAY = new DAnnotationAst[0];
    
    public final Token id;
    public final Expression[] parameters;
    
    public DAnnotationAst(Token id, List<Expression> parameters) {
        this.id = id;
        this.parameters = parameters.toArray(new Expression[parameters.size()]);
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i)
            b.append("    ");
        b.append(id.text);        
    }
}