package org.simantics.scl.compiler.internal.interpreted;

import org.simantics.scl.runtime.function.Function;


public class IConstant implements IExpression {
    private final Object value;

    public IConstant(Object value) {
        this.value = value;
    }
    
    @Override
    public Object execute(Object[] variableBindings) {
        return value;
    }
    
    @Override
    public String toString() {
        if(value == null)
            return "null";
        else if(value instanceof Number || value instanceof Function)
        	return value.toString();
        else if(value instanceof String)
        	return "\"" + value.toString() + "\"";
        else if(value instanceof Class)
        	return ((Class<?>)value).getSimpleName();
        else
            return "(" + value.toString() + "::" + value.getClass().getSimpleName() + ")";
    }
}
