package org.simantics.scl.compiler.internal.codegen.ssa;

import java.util.ArrayList;

import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.Printable;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;


public abstract class SSAExit implements Printable {
    SSABlock parent;
    public long location;

    public abstract void generateCode(MethodBuilder mb);

    public abstract void validate(SSAValidationContext context);

    public void simplify(SSASimplificationContext context) {
    }

    public abstract void destroy();
    
    @Override
    public String toString() {
        PrintingContext context = new PrintingContext();
        toString(context);
        return context.toString();
    }
    
    public SSABlock getParent() {
        return parent;
    }

    public abstract SSAExit copy(CopyContext context);
    public abstract void replace(TVar[] vars, Type[] replacements);

    public abstract void collectFreeVariables(SSAFunction function, ArrayList<ValRef> vars);

    public abstract Cont addParametersInFrontOf(ContRef contRef, Val[] newParameters, Val[] oldParameters, Cont proxy);
    
    public SSAFunction getParentFunction() {
        return parent.parent;
    }
    
    public void replaceByApply(ValRef valRef, Val function, Type[] typeParameters, Val[] parameters) {
        BoundVar target = new BoundVar(valRef.getBinding().getType());
        parent.addStatement(new LetApply(target, Types.NO_EFFECTS, function.createOccurrence(typeParameters), ValRef.createOccurrences(parameters)));
        valRef.replaceBy(target);
    }

    public boolean isJump(Cont cont, Val parameter) {        
        return false;
    }
    
    public abstract SSABlock[] getSuccessors();

    public void prepare(MethodBuilder mb) {
    }

    public abstract void forValRefs(ValRefVisitor visitor);

    public abstract void cleanup();
}