package org.simantics.scl.compiler.environment;

import java.util.ArrayList;
import java.util.Arrays;

import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;

public class EnvironmentFactoryImpl implements EnvironmentFactory {

    private final ModuleRepository environment;
    private final ImportDeclaration[] builtinImports;
    private final UpdateListener listener;
    
    public EnvironmentFactoryImpl(ModuleRepository environment,
            ImportDeclaration[] builtinImports, UpdateListener listener) {
        this.environment = environment;
        this.builtinImports = builtinImports;
        this.listener = listener;
    }

    @Override
    public Environment createEnvironment(ImportDeclaration[] imports) throws ImportFailureException {
        ArrayList<ImportDeclaration> acceptedBuiltinImports = 
                new ArrayList<ImportDeclaration>(builtinImports.length);
        loop: for(ImportDeclaration builtinImport : builtinImports) {
            for(ImportDeclaration decl : imports)
                if(decl.moduleName.equals(builtinImport.moduleName) &&
                        decl.localName.equals(builtinImport.localName))
                    continue loop;
            acceptedBuiltinImports.add(builtinImport);
        }
        ImportDeclaration[] is = Arrays.copyOf(
                acceptedBuiltinImports.toArray(new ImportDeclaration[acceptedBuiltinImports.size()]),
                acceptedBuiltinImports.size() + imports.length);
        System.arraycopy(imports, 0, is, acceptedBuiltinImports.size(), imports.length);
        return environment.createEnvironment(is, listener);
    }
    
    @Override
    public void addBuiltinDependencies(ConcreteModule module) {
        for(ImportDeclaration decl : builtinImports) {
            ImportDeclaration decl2 = new ImportDeclaration(decl.moduleName, null);
            module.addDependency(decl2);
        }
    }

}
