package org.simantics.scl.compiler.elaboration.java;

import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;

public class JavaMethodDeclaration extends Symbol {
    public String className;
    public EVar methodName;
    public TypeAst type;
    
    public JavaMethodDeclaration(long loc,
            String className, EVar methodName,
            TypeAst type) {
        this.location = loc;
        this.className = className;
        this.methodName = methodName;
        this.type = type;
    }
    
    @Override
    public String toString() {
    	return className + "#" + methodName.name + " :: " + type.toString();
    }
}
