package org.simantics.scl.compiler.elaboration.fundeps;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.parsing.declarations.FundepAst;


public class Fundep {
    public static final Fundep[] EMPTY_ARRAY = new Fundep[0];
    public final int[] from;
    public final int[] to;

    public Fundep(int[] from, int[] to) {
        this.from = from;
        this.to = to;
    }
    
    public Fundep(int[] from, int to) {
        this(from, new int[] {to});
    }

    private static int mapParameterName(String[] parameterNames, String name) {
        for(int i=0;i<parameterNames.length;++i)
            if(parameterNames[i].equals(name))
                return i;
        throw new InternalCompilerError("Fundep.mapParameterName error handling missing.");
    }

    private static int[] mapParameterNames(String[] parameterNames, String[] names) {
        int[] result = new int[names.length];
        for(int i=0;i<names.length;++i)
            result[i] = mapParameterName(parameterNames, names[i]);
        return result;
    }

    public static Fundep[] mapFundeps(String[] parameterNames, FundepAst[] fundeps) {
        Fundep[] result = new Fundep[fundeps.length];
        for(int i=0;i<fundeps.length;++i)
            result[i] = new Fundep(
                    mapParameterNames(parameterNames, fundeps[i].from), 
                    mapParameterName(parameterNames, fundeps[i].to));
        return result;
    }
}
