package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.ValRefBinder;
import org.simantics.scl.compiler.internal.parsing.Token;
import org.simantics.scl.compiler.types.Type;

public class IncludeStatement extends Statement implements ValRefBinder {
    public Token name;
    public Expression value;
    
    public CHRRuleset ruleset;
    public IVal storeVar; 
    
    public IncludeStatement(Token name, Expression value) {
        this.name = name;
        this.value = value;
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            value.setLocationDeep(loc);
        }
    }
    
    @Override
    public StatementGroup getStatementGroup() {
        return StatementGroup.CHR;
    }

    @Override
    public Expression toExpression(EnvironmentalContext context, boolean monadic, Expression in) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolvePattern(TranslationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mayBeRecursive() {
        return true;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SSAFunction getParentFunction() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void replaceByApply(ValRef valRef, Val function, Type[] typeParameters, Val[] parameters2) {
         throw new UnsupportedOperationException();
    }

}