package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EGetConstraint extends SimplifiableExpression {
    TPred constraint;
    public EVariable evidence;
        
    public EGetConstraint(long loc, TPred constraint) {
        super(loc);
        this.constraint = constraint;
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        Variable variable = new Variable("evidence");
        variable.setType(constraint);
        evidence = new EVariable(getLocation(), variable);
        evidence.setType(variable.getType());
        context.addConstraintDemand(evidence);
        return this;
    }
    
    @Override
    protected void updateType() throws MatchException {
        setType(constraint);
    }
    
    @Override
    public Expression simplify(SimplificationContext context) {
        return evidence.simplify(context);
    }
    
    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            if(evidence != null)
                evidence.setLocationDeep(loc);
        }
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

}
