package org.simantics.scl.compiler.elaboration.chr.ast;

import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRQuery;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public abstract class CHRAstQuery extends Symbol {
    public CHRQuery translate(TranslationContext context, CHRQueryTranslationMode mode) {
        ArrayList<CHRLiteral> literals = new ArrayList<CHRLiteral>(); 
        translate(context, mode, literals);
        return new CHRQuery(literals.toArray(new CHRLiteral[literals.size()]));
    }

    protected abstract void translate(TranslationContext context, CHRQueryTranslationMode mode, ArrayList<CHRLiteral> literals);

    public abstract void accept(CHRAstQueryVisitor visitor);
}
