package org.simantics.scl.compiler.compilation;

import java.util.ArrayList;

import gnu.trove.map.hash.TObjectLongHashMap;

public class CompilationTimer {
    private long initialTime, previousTime;
    private ArrayList<TimerEntry> entries = new ArrayList<TimerEntry>();
    private static TObjectLongHashMap<String> GLOBAL_TIMES = new TObjectLongHashMap<String>();
    
    private static class TimerEntry {
        public final String phaseName;
        public final long time;
        public final long cumulativeTime;
        
        public TimerEntry(String phaseName, long time, long cumulativeTime) {
            this.phaseName = phaseName;
            this.time = time;
            this.cumulativeTime = cumulativeTime;
        }        
    }
    
    public CompilationTimer() {
        initialTime = previousTime = System.nanoTime();
    }
    
    public void phaseFinished(String phaseName) {
        long time = System.nanoTime();
        entries.add(new TimerEntry(phaseName, time-previousTime, time-initialTime));
        previousTime = time;
    }
    
    public void suspendTimer() {
        long time = System.nanoTime();
        initialTime -= time;
        previousTime -= time;
    }
    
    public void continueTimer() {
        long time = System.nanoTime();
        initialTime += time;
        previousTime += time;
    }
    
    public void report(String moduleName) {
        synchronized(GLOBAL_TIMES) {
            System.out.println(moduleName);
            for(TimerEntry entry : entries) {
                long globalTime = GLOBAL_TIMES.adjustOrPutValue(entry.phaseName, entry.time, entry.time);
                System.out.println("    " + entry.phaseName + " " + entry.time*1e-6 
                        + "ms (cumulative: " + entry.cumulativeTime*1e-6 + "ms, global: " + globalTime*1e-6 + ")");
            }
        }
    }
}
