/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers.e4;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagramEditor.e4.DiagramViewer;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.e4.E4WorkbenchUtils;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ErrorLogger;

public class LinkBrowsingHandler
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    CanvasBoundsParticipant canvasBounds;
    @DependencyReflection.Dependency
    Selection selection;
    DiagramViewer viewer;
    ISessionContext sessionContext;

    public LinkBrowsingHandler(DiagramViewer viewer, ISessionContext context) {
        this.viewer = viewer;
        this.sessionContext = context;
    }

    public static Runnable editorActivator(MPart part, ResourceArray input, Consumer<MPart> successCallback) {
        String sourcePartId = part.getElementId();
        return LinkBrowsingHandler.editorActivator(sourcePartId, input, successCallback);
    }

    public Runnable elementSelectorZoomer(final ICanvasContext canvas, final Collection<Object> elementObjects, final boolean keepZoom) {
        return new Runnable(){

            @Override
            public void run() {
                IDiagram diagram = (IDiagram)canvas.getHintStack().getHint(DiagramHints.KEY_DIAGRAM);
                if (!$assertionsDisabled && diagram == null) {
                    throw new AssertionError();
                }
                if (!LinkBrowsingHandler.this.zoomToSelection(canvas, diagram, LinkBrowsingHandler.selectElement(canvas, diagram, elementObjects), keepZoom)) {
                    ThreadUtils.asyncExec((IThreadWorkQueue)canvas.getThreadAccess(), (Runnable)this);
                }
            }
        };
    }

    public static Set<IElement> selectElement(ICanvasContext canvas, IDiagram diagram, Collection<Object> elementObjects) {
        HashSet<IElement> selection = new HashSet<IElement>();
        DataElementMap dataMap = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        for (Object obj : elementObjects) {
            IElement element = dataMap.getElement(diagram, obj);
            if (element == null) {
                ErrorLogger.defaultLogWarning((String)("No element to select for object " + obj), (Throwable)new Exception());
                continue;
            }
            selection.add(element);
        }
        for (Selection s : canvas.getItemsByClass(Selection.class)) {
            s.setSelection(0, selection);
        }
        return selection;
    }

    public boolean zoomToSelection(ICanvasContext canvas, IDiagram diagram, Set<IElement> selection, boolean keepZoom) {
        TransformUtil util = (TransformUtil)canvas.getSingleItem(TransformUtil.class);
        Rectangle2D controlBounds = this.canvasBounds.getControlBounds();
        if (controlBounds == null) {
            return false;
        }
        Shape shp = ElementUtils.getElementBoundsOnDiagram(selection);
        if (shp == null) {
            return false;
        }
        Rectangle2D diagramRect = shp.getBounds2D();
        if (keepZoom) {
            double scaleFactor = GeometryUtils.getScale((AffineTransform)util.getTransform());
            double cwh = controlBounds.getWidth() / (scaleFactor * 2.0);
            double chh = controlBounds.getHeight() / (scaleFactor * 2.0);
            AffineTransform view = new AffineTransform();
            view.scale(scaleFactor, scaleFactor);
            view.translate(-diagramRect.getCenterX() + cwh, -diagramRect.getCenterY() + chh);
            util.setTransform(view);
        } else {
            MarginUtils.Margin margin = MarginUtils.marginOf((double)40.0, (double)0.0, (double)0.0);
            MarginUtils.Margins margins = new MarginUtils.Margins(margin, margin, margin, margin);
            util.fitArea(controlBounds, diagramRect, margins);
        }
        return true;
    }

    public static Runnable editorActivator(final String editorPartId, final ResourceArray input, final Consumer<MPart> successCallback) {
        return new Runnable(){

            @Override
            public void run() {
                MPart part = E4WorkbenchUtils.openEditor((String)editorPartId, (String)"", (String)"", (Resource)input.get(0));
                E4WorkbenchUtils.activatePart((MPart)part);
                successCallback.accept(part);
            }
        };
    }

    public static Resource getOwnerList(ReadGraph g, Resource listElement) throws DatabaseException {
        return OrderedSetUtils.getSingleOwnerList((ReadGraph)g, (Resource)listElement, (Resource)DiagramResource.getInstance((ReadGraph)g).Composite);
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleDoubleClick(MouseEvent.MouseDoubleClickedEvent me) {
        IElement e;
        Object data;
        if (this.sessionContext == null) {
            return false;
        }
        Set sel = this.selection.getSelection(0);
        if (sel.size() == 1 && (data = (e = (IElement)sel.iterator().next()).getHint(ElementHints.KEY_OBJECT)) instanceof Resource) {
            final Resource element = (Resource)data;
            this.sessionContext.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                    DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                    StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
                    if (!graph.isInstanceOf(element, dr.UpwardLink) && graph.isInstanceOf(element, dr.Link)) {
                        Resource thisDiagram = LinkBrowsingHandler.getOwnerList(graph, element);
                        if (thisDiagram == null) {
                            return;
                        }
                        Resource target = graph.getPossibleObject(element, dr.HasLinkTarget);
                        if (target == null) {
                            return;
                        }
                        Resource otherDiagram = LinkBrowsingHandler.getOwnerList(graph, target);
                        if (otherDiagram == null) {
                            return;
                        }
                        Resource component = graph.getPossibleObject(target, mr.ElementToComponent);
                        if (component == null) {
                            return;
                        }
                        Resource type = graph.getSingleType(component, sr.Component);
                        if (type == null) {
                            return;
                        }
                        Resource definedBy = graph.getPossibleObject(type, sr.IsDefinedBy);
                        if (definedBy == null) {
                            return;
                        }
                        Resource diagram = graph.getPossibleObject(definedBy, mr.CompositeToDiagram);
                        if (diagram == null) {
                            return;
                        }
                    }
                }
            });
        }
        return false;
    }
}

