/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.OpenDiagramFromConfigurationAdapter;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ISelectionUtils;

public class OpenDiagramFromIssue
extends AbstractResourceEditorAdapter {
    private static final String EDITOR_ID = "org.simantics.modeling.ui.plainDiagramEditor";

    public OpenDiagramFromIssue() {
        super("Open Diagram Containing Referenced Component", Activator.COMPOSITE_ICON);
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph g, Object input) throws DatabaseException {
        return OpenDiagramFromIssue.extractContext(g, input) != null;
    }

    public void openEditor(final Object input) throws Exception {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                Pair data = OpenDiagramFromIssue.extractContext(g, input);
                if (data != null) {
                    OpenDiagramFromConfigurationAdapter.openEditor(g, (Resource)data.first, OpenDiagramFromIssue.this.getEditorId(), (Collection)data.second);
                }
            }
        });
    }

    private static Pair<Resource, Collection<Object>> extractContext(ReadGraph graph, Object input) throws DatabaseException {
        Pair<Resource, Collection<Object>> result;
        Pair<Variable, Resource> p = OpenDiagramFromIssue.extractInput(graph, input);
        Pair<Resource, Collection<Object>> pair = result = p.first != null ? OpenDiagramFromIssue.findConfigurationAndObjects(graph, (Variable)p.first) : null;
        if (result == null && p.second != null) {
            result = OpenDiagramFromIssue.findConfigurationAndObjects(graph, (Resource)p.second);
        }
        return result;
    }

    protected static <T> T extractContent(ReadGraph graph, Object input, WorkbenchSelectionContentType<T> contentType, Class<T> contentClass) throws DatabaseException {
        WorkbenchSelectionElement single;
        if (contentClass.isInstance(input)) {
            return contentClass.cast(input);
        }
        if (input instanceof WorkbenchSelectionElement && (single = (WorkbenchSelectionElement)input) != null) {
            return (T)single.getContent(contentType);
        }
        return (T)ISelectionUtils.filterSingleSelection((Object)input, contentClass);
    }

    protected static Pair<Variable, Resource> extractInput(ReadGraph graph, Object input) throws DatabaseException {
        return Pair.make((Object)OpenDiagramFromIssue.extractContent(graph, input, new AnyVariable((RequestProcessor)graph), Variable.class), (Object)OpenDiagramFromIssue.extractContent(graph, input, new AnyResource((RequestProcessor)graph), Resource.class));
    }

    protected static Pair<Resource, Collection<Object>> findConfigurationAndObjects(ReadGraph graph, Resource issue) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(issue, ISSUE.Issue)) {
            return null;
        }
        List contexts = (List)graph.getRelatedValue2(issue, ISSUE.Issue_contexts);
        return contexts != null ? OpenDiagramFromIssue.findConfigurationAndObjects(graph, contexts) : null;
    }

    protected static Pair<Resource, Collection<Object>> findConfigurationAndObjects(ReadGraph graph, Variable v) throws DatabaseException {
        List contexts = (List)v.getPossiblePropertyValue(graph, IssueResource.getInstance((ReadGraph)graph).Issue_contexts);
        return contexts != null ? OpenDiagramFromIssue.findConfigurationAndObjects(graph, contexts) : null;
    }

    protected static Pair<Resource, Collection<Object>> findConfigurationAndObjects(ReadGraph graph, List<Resource> contexts) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource context : contexts) {
            Resource config;
            Resource element;
            Resource config2;
            Set types = graph.getTypes(context);
            if (types.contains(DIA.Element)) {
                config2 = OpenDiagramFromIssue.findConfigurationForElement(graph, context);
                if (config2 == null) continue;
                Set<Resource> elements = Collections.singleton(context);
                return Pair.make((Object)config2, elements);
            }
            if (types.contains(STR.Component) && !types.contains(STR.Composite)) {
                config2 = graph.getPossibleObject(context, L0.PartOf);
                if (config2 == null) continue;
                return Pair.make((Object)config2, OpenDiagramFromIssue.findElementObjects(graph, context));
            }
            if (!types.contains(STR.Connection) || (element = graph.getPossibleObject(context, MOD.ConnectionToDiagramConnection)) == null || (config = OpenDiagramFromIssue.findConfigurationForElement(graph, element)) == null) continue;
            return Pair.make((Object)config, Collections.singleton(element));
        }
        return null;
    }

    protected static Resource findConfigurationForElement(ReadGraph graph, Resource element) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource diagram = graph.getPossibleObject(element, L0.PartOf);
        if (diagram == null) {
            return null;
        }
        return graph.getPossibleObject(diagram, MOD.DiagramToComposite);
    }

    protected static Collection<Object> findElementObjects(ReadGraph g, Resource component) throws DatabaseException {
        Collection<Object> result = OpenDiagramFromIssue.findElementObjects(g, component, "");
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        for (Resource element : g.getObjects(component, MOD.HasParentComponent_Inverse)) {
            result.add(element);
        }
        return result;
    }

    public static Collection<Object> findElementObjects(ReadGraph g, Resource component, String rviFromComponent) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        ArrayList<Object> selectedObjects = new ArrayList<Object>(4);
        if (rviFromComponent.isEmpty()) {
            for (Resource element : g.getObjects(component, MOD.ComponentToElement)) {
                if (g.isInstanceOf(element, DIA.Flag) && FlagUtil.isExternal((ReadGraph)g, (Resource)element)) {
                    selectedObjects.clear();
                    selectedObjects.add(element);
                    break;
                }
                if (g.isInstanceOf(element, DIA.RouteGraphConnection)) {
                    selectedObjects.add(element);
                    continue;
                }
                if (g.isInstanceOf(element, DIA.Connection)) {
                    ConnectionUtil cu = new ConnectionUtil(g);
                    cu.gatherConnectionParts(element, selectedObjects);
                    continue;
                }
                selectedObjects.add(element);
            }
        } else {
            for (Resource refElement : g.getObjects(component, MOD.HasParentComponent_Inverse)) {
                String suffix;
                Resource relation = g.getPossibleObject(refElement, MOD.HasReferenceRelation);
                if (relation == null || (suffix = (String)g.getPossibleRelatedValue(relation, L0.HasName, (Binding)Bindings.STRING)) == null || !rviFromComponent.equals(suffix)) continue;
                selectedObjects.add(refElement);
            }
        }
        return selectedObjects;
    }
}

