/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.modeling.ui.diagramEditor.DiagramViewer;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Pair;

public class ModelingUIUtils {
    public static DiagramViewer tryGetDiagramViewer(ExecutionEvent event) {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editorPart == null) {
            return null;
        }
        if (editorPart instanceof DiagramEditor) {
            return (DiagramViewer)editorPart.getAdapter(DiagramViewer.class);
        }
        return null;
    }

    public static ICanvasContext tryGetCanvasContext(ExecutionEvent event) {
        DiagramViewer viewer = ModelingUIUtils.tryGetDiagramViewer(event);
        if (viewer != null) {
            return viewer.getAdapter(ICanvasContext.class);
        }
        return null;
    }

    protected static void findSCLQueryTypes(ReadGraph graph, Resource indexRoot, Map<Resource, Pair<String, ImageDescriptor>> map) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(MOD.SCLQueryType, Instances.class);
        String modelURI = graph.getURI(indexRoot);
        for (Resource _res : query.find(graph, indexRoot)) {
            String parentURI;
            Resource parent;
            String label;
            String name;
            if (graph.hasStatement(_res, L0.Abstract)) continue;
            Resource res = graph.getPossibleObject(_res, L0.HasRange_Inverse);
            if (res == null) {
                name = (String)graph.getPossibleRelatedValue(_res, L0.HasName, (Binding)Bindings.STRING);
                if (name == null) continue;
                label = (String)graph.getPossibleRelatedValue2(_res, L0.HasLabel, (Binding)Bindings.STRING);
                if (label != null && !name.equals(label)) {
                    name = String.valueOf(label) + " (" + name + ")";
                }
                if ((parent = graph.getPossibleObject(_res, L0.PartOf)) == null) continue;
                parentURI = graph.getURI(parent);
                if (parentURI.startsWith(modelURI) && (parentURI = parentURI.substring(modelURI.length())).startsWith("/")) {
                    parentURI = parentURI.substring(1);
                }
                name = String.valueOf(name) + " - " + URIStringUtils.unescape((String)parentURI);
                map.put(_res, (Pair<String, ImageDescriptor>)new Pair((Object)name, null));
                continue;
            }
            name = (String)graph.getPossibleRelatedValue(res, L0.HasName, (Binding)Bindings.STRING);
            if (name == null) continue;
            label = (String)graph.getPossibleRelatedValue2(res, L0.HasLabel, (Binding)Bindings.STRING);
            if (label != null && !name.equals(label)) {
                name = String.valueOf(label) + " (" + name + ")";
            }
            if ((parent = graph.getPossibleObject(_res, L0.PartOf)) == null) continue;
            parentURI = graph.getURI(parent);
            if (parentURI.startsWith(modelURI) && (parentURI = parentURI.substring(modelURI.length())).startsWith("/")) {
                parentURI = parentURI.substring(1);
            }
            name = String.valueOf(name) + " - " + URIStringUtils.unescape((String)parentURI);
            map.put(_res, (Pair<String, ImageDescriptor>)new Pair((Object)name, null));
        }
    }

    public static void queryUserSelectedQueryType(final Map<Resource, Pair<String, ImageDescriptor>> map, final Consumer<Resource> selectionCallback) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] result;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ResourceSelectionDialog3<Resource> dialog = new ResourceSelectionDialog3<Resource>(shell, map, "Select query type from list"){

                    protected IDialogSettings getBaseDialogSettings() {
                        return Activator.getDefault().getDialogSettings();
                    }
                };
                if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                    Resource res = (Resource)result[0];
                    selectionCallback.accept(res);
                }
            }
        });
    }

    public static void newSCLQuery(final Resource parent, final Resource indexRoot) throws DatabaseException {
        if (indexRoot == null) {
            return;
        }
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                HashMap<Resource, Pair<String, ImageDescriptor>> map = new HashMap<Resource, Pair<String, ImageDescriptor>>();
                ModelingUIUtils.findSCLQueryTypes(graph, indexRoot, map);
                ModelingUIUtils.queryUserSelectedQueryType(map, selected -> Simantics.getSession().async((WriteInterface)new WriteRequest((Resource)selected){
                    private final /* synthetic */ Resource val$selected;
                    {
                        this.val$selected = resource2;
                    }

                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        Simantics.applySCL((String)"Simantics/Query", (String)"createSCLQueryDefault", (ReadGraph)g, (Object[])new Object[]{parent, this.val$selected});
                    }
                }));
            }
        });
    }
}

