package org.simantics.modeling.scl;


import java.util.Collection;
import java.util.Collections;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.PrecompiledModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.runtime.SCLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gnu.trove.procedure.TObjectProcedure;

public enum OntologyModuleSourceRepository implements ModuleSourceRepository {
    INSTANCE;
    
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyModuleSourceRepository.class);

	static class ModuleSourceRequest extends UnaryRead<String, ModuleSource> {

        public ModuleSourceRequest(String moduleName) {
			super(moduleName);
		}

		@Override
        public ModuleSource perform(ReadGraph graph) throws DatabaseException {
            return new PrecompiledModuleSource(new OntologyModule(graph, parameter), -1.0);
        }

    };
	
    @Override
    public ModuleSource getModuleSource(final String moduleName,
            UpdateListener listener) {
        if(!moduleName.startsWith("http://"))
            return null; // Don't do a graph request if this cannot be a resource
        
        ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get("graph");
        
        try {
            if(graph != null) {
                return new PrecompiledModuleSource(new OntologyModule(graph, moduleName), -1.0);
            }

            return Simantics.getSession().syncRequest(new ModuleSourceRequest(moduleName));
        } catch(DatabaseException e) {
            LOGGER.error("Failed to read ontology module " + moduleName + ".", e);
            return null;
        }
    }

    @Override
    public void forAllModules(TObjectProcedure<String> procedure) {
    }
    
    @Override
    public Collection<String> getModuleNames() {
        return Collections.emptyList();
    }

}
