package org.simantics.modeling.scl;

import static org.simantics.scl.compiler.elaboration.expressions.Expressions.externalConstant;
import gnu.trove.map.hash.THashMap;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.CheckRelation;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.types.Types;

public class GraphEntityType implements SCLEntityType {

    Resource type;
    THashMap<String, GraphAttribute> attributeMap = new THashMap<String, GraphAttribute>(); 
    
    public GraphEntityType(ReadGraph graph, Resource type) throws DatabaseException {
        this.type = type;
        Layer0 L0 = Layer0.getInstance(graph);
        for(Resource stype : graph.getSupertypes(type))
            addSupertype(graph, L0, stype);
        addSupertype(graph, L0, type);
        addRelation(graph, L0, L0.PartOf);
    }
    
    private void addSupertype(ReadGraph graph, Layer0 L0, Resource type) throws DatabaseException {
        for(Resource relation : graph.getObjects(type, L0.DomainOf))
            addRelation(graph, L0, relation);
    }
    
    private void addRelation(ReadGraph graph, Layer0 L0, Resource relation) throws DatabaseException {
        String relationName = (String)graph.getRelatedValue(relation, L0.HasName, Bindings.STRING);
        attributeMap.put(relationName, new GraphAttribute(OntologyModule.createRelation(graph, relation)));
    }

    private static final Name DB_isInstanceOf = Name.create("Simantics/DB", "isInstanceOf");
    
    @Override
    public Query generateQuery(TranslationContext context, Variable base,
            AttributeBinding[] attributeBindings) {
        Query[] queries = new Query[attributeBindings.length+1];
        for(int i=0;i<attributeBindings.length;++i) {
            AttributeBinding binding = attributeBindings[i];
            GraphAttribute attribute = (GraphAttribute)binding.attribute;
            SCLRelation relation = attribute.relation;
            queries[i] = new QAtom(relation, new EVariable(base), new EVariable(binding.variable));
        }
        queries[attributeBindings.length] = new QAtom(CheckRelation.INSTANCE,
                new EApply(
                        new EConstant(context.getEnvironment().getValue(DB_isInstanceOf)),
                        new EVariable(base),
                        externalConstant(type, Types.RESOURCE)));
        return new QConjunction(queries);
    }

    @Override
    public Attribute getAttribute(String name) {
        return attributeMap.get(name);
    }
    
    public static class GraphAttribute implements Attribute {
        SCLRelation relation;
        Expression[] evidence;

        public GraphAttribute(SCLRelation relation) {
            this.relation = relation;
        }
    }

}
