package org.simantics.modeling.migration;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;

public class DocumentCleanupMigrationStep implements MigrationStep {

    @Override
    public void applyTo(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
    	
        final Resource indexRoot = MigrationUtils.getResource(monitor, session, state);
        if(indexRoot == null) return;

        session.sync(new WriteRequest() {
        	
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
            	
            	Layer0 L0 = Layer0.getInstance(graph);
            	DocumentResource DOC = DocumentResource.getInstance(graph);
            	
            	for(Resource model : graph.getObjects(indexRoot, L0.ConsistsOf)) {
        			for(Resource instance : ModelingUtils.searchByType(graph, model, DOC.ScenegraphDocument)) {
        				if(!graph.hasStatement(instance, DOC.HasDocumentation_Inverse)) {
        					System.err.println("Removing stray document " + graph.getURI(instance));
        					RemoverUtil.remove(graph, instance);
        				}
        			}
            	}

            }

        });

    }

}
