package org.simantics.modeling.adapters;

import org.simantics.db.Metadata;
import org.simantics.db.Session;

/**
 * A tagging metadata entry that is used for marking a graph transaction as one
 * that should not be processed by change history update mechanisms.
 * 
 * @author Tuukka Lehtonen
 */
public class SkipChangeHistoryUpdate implements Metadata {

	@Override
	public byte[] serialise(Session session) {
		return new byte[0];
	}

	public static SkipChangeHistoryUpdate deserialise(Session session, byte[] input) {
		return new SkipChangeHistoryUpdate();
	}

}
