/*******************************************************************************
 * Copyright (c) 2014 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.adapter.StringModifierFactory;
import org.simantics.db.layer0.adapter.impl.RelatedEntityNameModifier;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

/**
 * @author Tuukka Lehtonen
 */
public class ConnectionRelationStringModifierFactory implements StringModifierFactory {

	private Resource subject;

	public ConnectionRelationStringModifierFactory(Resource subject) throws DatabaseException {
		this.subject = subject;
	}

	@Override
	public StringModifier createModifier(ReadGraph graph, Resource relation, Resource property) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);

		// Names require special care in validation and modification.
		if (L0.HasName.equals(relation)) {
			// Always rename all (configuration and diagram) connection relations 
			ModelingResources MOD = ModelingResources.getInstance(graph);
			Resource connectionRelation = graph.getPossibleObject(subject, MOD.DiagramConnectionRelationToConnectionRelation);
			Resource subject = connectionRelation != null ? connectionRelation : this.subject;
			return new RelatedEntityNameModifier(graph, subject, property, MOD.ConnectionRelationToDiagramConnectionRelation);
		}

		return null;
	}

}
