package org.simantics.modeling.adapters;

import org.simantics.db.Metadata;
import org.simantics.db.Session;

/**
 * A tagging metadata entry that is used for marking a graph transaction as one
 * that was was at least partly caused by changes made to the change history of
 * model entities.
 * 
 * @author Tuukka Lehtonen
 */
public class ChangeHistoryUpdated implements Metadata {

	@Override
	public byte[] serialise(Session session) {
		return new byte[0];
	}

	public static ChangeHistoryUpdated deserialise(Session session, byte[] input) {
		return new ChangeHistoryUpdated();
	}

}
