/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.actions;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.operations.Operation;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.persistent.IContextMap;
import org.simantics.utils.ui.ErrorLogger;

public class DisconnectFlag extends Operation {

    public DisconnectFlag() {
        super("Disconnect");
    }

    @Override
    public void exec(Session session, IContextMap parameters) {
        final Resource flag = (Resource) parameters.get(SUBJECT);
        session.asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph g) throws DatabaseException {
                disconnectFlags(g, Collections.singletonList(flag));
            }
        }, new Callback<DatabaseException>() {
            @Override
            public void run(DatabaseException parameter) {
                if (parameter != null)
                    ErrorLogger.defaultLogError("Flag disconnect failed, see exception for details.", parameter);
            }
        });
    }

    public static int disconnectFlags(WriteGraph graph, List<Resource> flags) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        int count = 0;
        for (Resource flag : flags) {
            Set<Resource> counterParts = FlagUtil.getCounterparts(graph, flag,
                    new HashSet<Resource>(Collections.singleton(flag)));
            FlagUtil.disconnectFlag(graph, flag);
            for (Resource f : counterParts)
                graph.denyValue(f, L0.HasLabel);
        }
        return count;
    }

}
