package org.simantics.modeling;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;

public class NewSymbolGroupRequest extends WriteResultRequest<Resource> {
    String name;
    Resource model;
    Resource symbolGroup;

    public NewSymbolGroupRequest(String name, Resource model) {
        this.name = name;
        this.model = model;
    }

    @Override
    public Resource perform(WriteGraph graph) throws DatabaseException {
        return createNewSymbolGroup(graph, model, name);
    }
    
    public static Resource createNewSymbolGroup(WriteGraph graph, Resource model, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);

        // Symbol group
        Resource symbolGroup = graph.newResource();
        graph.claim(symbolGroup, L0.PartOf, model);    
        graph.claim(symbolGroup, L0.InstanceOf, DIA.SymbolReferenceLibrary);

        // Name
        graph.claimLiteral(symbolGroup, L0.HasName, name);
        return symbolGroup;
    }
}