/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fileimport.ui;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.fileimport.FileImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFileHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportFileHandler.class);

    @CanExecute
    public boolean canExecute() {
        return !FileImportService.supportedExtensionsWithFilters().isEmpty();
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell) {
        Map extensions = FileImportService.supportedExtensionsWithFilters();
        String[] filterExtensions = extensions.keySet().toArray(new String[extensions.keySet().size()]);
        String[] filterNames = extensions.values().toArray(new String[extensions.values().size()]);
        int i = 0;
        while (i < filterExtensions.length) {
            String extension = filterExtensions[i];
            if (!extension.startsWith("*.")) {
                System.err.println("Invalid extension filter provied: " + extension);
            }
            ++i;
        }
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setText("Choose File");
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterNames(filterNames);
        String fileName = dialog.open();
        if (fileName == null) {
            return;
        }
        FileImportService.performFileImport((Path)Paths.get(fileName, new String[0]), Optional.of(t -> LOGGER.error("Could not import file " + fileName, t)));
    }
}

