/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.scl.SCLDatabaseException;
import org.simantics.document.server.DocumentException;
import org.simantics.scl.compiler.module.repository.ImportFailure;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.top.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeRequestUtils.class);

    public static String formatErrorMessage(String name, Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof DocumentException) {
            return t.getMessage();
        }
        if (t instanceof MissingVariableException) {
            return "Evaluation of property '" + name + "' failed\n" + t.getMessage();
        }
        if (t instanceof SCLDatabaseException) {
            return t.getMessage();
        }
        if (t instanceof NotFoundException) {
            return t.getMessage();
        }
        if (t instanceof ImportFailureException) {
            ImportFailureException e = (ImportFailureException)t;
            StringBuilder sb = new StringBuilder();
            sb.append("The following SCL modules failed to compile:\n");
            for (ImportFailure f : e.failures) {
                sb.append(" " + f.moduleName + "\n");
            }
            return sb.toString();
        }
        LOGGER.error("Node request error:", t);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        t.printStackTrace(ps);
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return baos.toString();
        }
    }
}

